/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.transaction;

/**
 * 事务接口定义，包括提交、回滚、关闭以及判断是否已提交和已回滚
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface Transaction
{
    /** 获取事务服务编号 */
    public String getId();
    
    /** 开始事务 */
    public Transaction begin() throws Exception;
    
    /** 提交事务 */
    public void commit() throws Exception;
    
    /** 回滚事务 */
    public void rollback() throws Exception;
    
    /** 关闭事务 */
    public void close() throws Exception;
    
    /** 事务是否已提交 */
    public boolean isCommitted();
    
    /** 事务是否已回滚 */
    public boolean isRollbacked();
    
    /** 事务是否已关闭 */
    public boolean isClosed();
}
