/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.paging;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Validates;

/**
 * 分页显示调用类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Pagings")
public class Pagings
{
    /*******************************************************************/
    //分页操作信息，提供超链接调用方式和对应的简单调用模式
    /*******************************************************************/
    public static String toHtmlLinkAll5(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, true, true, true, true, true, true, true, true, 5, false);
    }

    public static String toHtmlLinkAll10(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, true, true, true, true, true, true, true, true, 10, false);
    }

    public static String toHtmlLinkAllDiv5(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, true, true, true, true, true, true, true, true, 5, true);
    }

    public static String toHtmlLinkAllDiv10(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, true, true, true, true, true, true, true, true, 10, true);
    }
    
    public static String toHtmlLinkSeg5(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, false, false, false, false, false, false, false, false, 5, false);
    }

    public static String toHtmlLinkSeg10(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, false, false, false, false, false, false, false, false, 10, false);
    }
    
    public static String toHtmlLinkSegDiv5(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, false, false, false, false, false, false, false, false, 5, true);
    }

    public static String toHtmlLinkSegDiv10(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, false, false, false, false, false, false, false, false, 10, true);
    }

    public static String toHtmlLinkPN(PageResult<?> result, String link)
    {
        return toHtmlLink(result, link, false, false, false, false, false, true, true, false, 0, false);
    }
    
    public static String toHtmlLink(PageResult<?> result, String link, boolean isTotal, boolean isPageSize, boolean isTotalPages, boolean isPageNo, boolean isFirst, boolean isPrevious,
        boolean isNext, boolean isLast, int segmentSize, boolean isDiv)
    {
        if (result == null)
            result = PageBuilder.newResult(20);
        
        String absLink = link + result.getConditionUrl();
        if (Validates.isNotEmpty(result.getConditionUrl()))
            absLink += "&";
        else
           absLink += "?";
        
        StringBuilder strb = new StringBuilder();
        if(isTotal)
            strb.append("共<font color=\"red\">" + result.total() + "</font>条&nbsp;");
        if(isPageSize)
            strb.append("每页<font color=\"red\">" + result.pageSize() + "</font>条&nbsp;");
        if(isTotalPages)
            strb.append("共<font color=\"red\">" + result.totalPages() + "</font>页&nbsp;");
        if(isPageNo)
            strb.append("当前第<font color=\"red\">" + result.pageNo() + "</font>页&nbsp;");
                
        if (isFirst)
        {
            if (result.hasFirst())
                strb.append("<a href=\"" + absLink + "page=1\">首页</a>&nbsp;");
            else
                strb.append("首页&nbsp;");
        }
        
        if (isPrevious)
        {
            if (result.hasPrevious())
                strb.append("<a href=\"" + absLink + "page=" + (result.pageNo() - 1) + "\">上一页</a>&nbsp;");
            else
                strb.append("上一页&nbsp;");
        }
        
        if (isNext)
        {
            if (result.hasNext())
                strb.append("<a href=\"" + absLink + "page=" + (result.pageNo() + 1) + "\">下一页</a>&nbsp;");
            else
                strb.append("下一页&nbsp;");
        }
        
        if (isLast)
        {
            if (result.hasLast())
                strb.append("<a href=\"" + absLink + "page="+ result.totalPages() + "\">末页</a>&nbsp;");
            else
                strb.append("末页&nbsp;");
        }
        
        if (segmentSize > 0)
        {
            int lBound = result.getLSegmentNo(segmentSize);
            int rBound = result.getRSegmentNo(segmentSize);
            
            if (isDiv)
            {
                strb.append("<div style=\"float:right;height:20px;line-height:20px;min-width:20px;white-space:nowrap;\">");
                if (result.hasLSegment(segmentSize))
                    strb.append("<a href=\""+absLink+"page="+(lBound - 1)+"\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;cursor:pointer;'><<</div></a>");
                    
                for (int i=lBound; i<rBound; i++)
                {
                    if (result.pageNo() != i)
                        strb.append("<a href=\""+absLink+"page="+ i +"\"><div style='float:left;height:20px;line-height:20px;min-width:20px;white-space:nowrap;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>"+i+"</div></a>");
                    else
                        strb.append("<div style='float:left;height:20px;line-height:20px;width:20px;color:#993333;background-color:#F2D2D2;border:1px solid #f9631f;text-align:center;margin-left:5px;cursor:pointer;'>"+i+"</div>");
                }
                
                if (result.hasRSegment(segmentSize))
                    strb.append("<a href=\""+absLink+"page="+ rBound +"\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>>></div></a>&nbsp;");
           
                strb.append("</div>");
            }
            else
            {
                strb.append("页码:");
                if (result.hasLSegment(segmentSize))
                    strb.append("<a href=\"" + absLink + "page="+ (lBound - 1) +"\"><<<</a>&nbsp;");
                    
                for (int i=lBound; i<rBound; i++)
                {
                    strb.append("<a href=\"" + absLink + "page="+ i +"\">"+i+"</a>&nbsp;");
                }
                
                if (result.hasRSegment(segmentSize))
                    strb.append("<a href=\"" + absLink + "page="+ rBound +"\">>>></a>&nbsp;");
            }
        }
        return strb.toString();
    }

    /*******************************************************************/
    //分页操作信息，提供JS方法onclick调用方式和其对应的简单调用模式
    /*******************************************************************/
    
    public static String toHtmlClickAll5(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 5, false);
    }

    public static String toHtmlClickAll10(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 10, false);
    }

    public static String toHtmlClickSeg5(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 5, false);
    }

    public static String toHtmlClickSeg10(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 10, false);
    }
    
    public static String toHtmlClickAllDiv5(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 5, true);
    }

    public static String toHtmlClickAllDiv10(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, true, true, true, true, true, true, true, true, 10, true);
    }

    public static String toHtmlClickSegDiv5(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 5, true);
    }

    public static String toHtmlClickSegDiv10(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, false, false, false, false, false, false, false, false, 10, true);
    }

    public static String toHtmlClickPN(PageResult<?> result, String jsMethod)
    {
        return toHtmlClick(result, jsMethod, false, false, false, false, false, true, true, false, 0, false);
    }
    
    public static String toHtmlClick(PageResult<?> result, String jsMethod, boolean isTotal, boolean isPageSize, boolean isTotalPages, boolean isPageNo, 
        boolean isFirst, boolean isPrevious, boolean isNext, boolean isLast, int segmentSize, boolean isDiv)
    {
        if (result == null)
            result = PageBuilder.newResult(20);
        
        StringBuilder strb = new StringBuilder();
        if (isTotal)
            strb.append("共<font color=\"red\">"+result.total()+"</font>条&nbsp;");
        if (isPageSize)
            strb.append("每页<font color=\"red\">"+result.pageSize()+"</font>条&nbsp;");
        if (isTotalPages)
            strb.append("共<font color=\"red\">"+result.totalPages()+"</font>页&nbsp;");
        if (isPageNo)
            strb.append("当前第<font color=\"red\">"+result.pageNo()+"</font>页&nbsp;");;

        if (isFirst)
        {
            if (result.hasFirst())
                strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('1');\">首页</a>&nbsp;");
            else
                strb.append("首页&nbsp;");
        }
        
        if (isPrevious)
        {
            if (result.hasPrevious())
                strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+(result.pageNo() - 1) + "');\">上一页</a>&nbsp;");
            else
                strb.append("上一页&nbsp;");
        }
        
        if (isNext)
        {
            if (result.hasNext())
                strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+(result.pageNo() + 1) + "');\">下一页</a>&nbsp;");
            else
                strb.append("下一页&nbsp;");
        }
        
        if (isLast)
        {
            if (result.hasLast())
                strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+ result.totalPages() + "');\">末页</a>&nbsp;");
            else
                strb.append("末页&nbsp;");
        }
        
        if (segmentSize > 0)
        {
            int lBound = result.getLSegmentNo(segmentSize);
            int rBound = result.getRSegmentNo(segmentSize);
            
            if (isDiv)
            {
                strb.append("<div style=\"float:right;height:20px;line-height:20px;min-width:20px;white-space:nowrap;\">");
                if (result.hasLSegment(segmentSize))
                    strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+(lBound - 1)+"');\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;cursor:pointer;'><<</div></a>");
                    
                for (int i=lBound; i<rBound; i++)
                {
                    if (result.pageNo() != i)
                        strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+ i +"');\"><div style='float:left;height:20px;line-height:20px;min-width:20px;white-space:nowrap;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>"+i+"</div></a>");
                    else
                        strb.append("<div style='float:left;height:20px;line-height:20px;width:20px;color:#993333;background-color:#F2D2D2;border:1px solid #f9631f;text-align:center;margin-left:5px;cursor:pointer;'>"+i+"</div>");
                }
                
                if (result.hasRSegment(segmentSize))
                    strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+ rBound +"');\"><div style='float:left;height:20px;line-height:20px;width:20px;border:1px solid #D3D3D3;text-align:center;margin-left:5px;cursor:pointer;'>>></div></a>&nbsp;");
           
                strb.append("</div>");
            }
            else
            {
                strb.append("页码:");
                if (result.hasLSegment(segmentSize))
                    strb.append("<a href=\"javascript:void(0);\" oonclick=\""+jsMethod+"('"+(lBound - 1)+"');\"><<<</a>&nbsp;");
                    
                for (int i=lBound; i<rBound; i++)
                {
                    strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+ i +"');\">"+i+"</a>&nbsp;");
                }
                
                if (result.hasRSegment(segmentSize))
                    strb.append("<a href=\"javascript:void(0);\" onclick=\""+jsMethod+"('"+ rBound +"');\">>>></a>&nbsp;");
            }
       }
        
        return strb.toString();
    }
}
