/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.paging;

/**
 * 分页显示接口定义，支持两个方法<br>
 * 1、来自链接的分页显示<br>
 * 2、来自JS函数的分页显示<br>
 *
 * @version v1.0.0 @author zouzhigang 2017-11-15 新建与整理
 */
public interface Paging
{
    /**
     * 提供传入的是URL链接的分页显示
     * 
     * @param result        结果集
     * @return              分页显示HTML
     */
    public String toHtmlLink(PageResult<?> result);
    
    /**
     * 提供传入的是URL链接的分页显示
     * 
     * @param result        结果集
     * @param link          URL链接，当前页可以传入null或""
     * @return              分页显示HTML
     */
    public String toHtmlLink(PageResult<?> result, String link);
    
    /**
     * 提供传入的是Js函数名的分页显示
     * 
     * @param result        结果集
     * @param jsMethod      Js函数
     * @return              分页显示HTML
     */
    public String toHtmlClick(PageResult<?> result, String jsMethod);
}
