/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging.logger;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.util.Files;

/**
 * 文件大小滚动日志器，根据大小切换日志文件，格式如info.log,info.log.1,...
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class FileSizeLogger extends FileLogger
{
    private Object lock = new Object();     //文件锁
    
    /**
     * 日志记录器记录日志
     * 
     * @param log       日志对象
     * @param level     日志级别
     * @param message   日志消息
     * @param throwable 日志异常
     */
    public void logger(Log log, int level, String message, Throwable throwable)
    {
        if (level < super.getLevelMin() || level > super.getLevelMax())
            return;
        
        if (super.getFileSize() >= (super.getFileMaxSize() * 1024 * 1024))
            doConvertWriter(false);
            
        print(level, message, throwable);
    }
    
    @Override
    public void setFilePath(String filePath)
    {
        super.setFilePath(filePath);
        doConvertWriter(true);
    }
    
    /** 变更文件输出器 */
    private void doConvertWriter(boolean first)
    {
        synchronized (lock)
        {
            //再次判断，因为同步之前可能并发到达，第一个处理了，后面的无需处理
            if (first)
            {//由外部第一次设置时
                
                if (super.getWriter() != null)
                    return;//当前输出器已创建成功，表示已创建，直接返回
                
                if (super.getFileSize() >= super.getFileMaxSize())
                {//如果当前的大于最大值，则删除可能大于该索引的值，重命名 .1,.2,.3成.2,.3,.4
                    Files.removeMaxFileAndRenameFile(fileDir, fileName, fileMaxNum, true);
                }
                
                //创建新的当前输出器
                super.createWriter();
            }
            else
            {//由日志器本身判断
                
                if (super.getFileSize() < super.getFileMaxSize())
                    return;//当前文件小于最大值，表示已创建，直接返回
                
                //关闭上一个输出器
                super.closeWriter();    
                
                //删除可能大于该索引的值，重命名 .1,.2,.3成.2,.3,.4
                Files.removeMaxFileAndRenameFile(fileDir, fileName, fileMaxNum, true);
                
                //创建新的当前输出器
                super.createWriter();
            }
        }
    }
}
