/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging.logger;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.Logger;

/**
 * 定义一个空增加器<br><br>
 * 主要表示为日志配制时未配置支持的增加器
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class EmptyLogger implements Logger
{
    /**
     * 日志记录器记录日志
     * 
     * @param log       日志对象
     * @param level     日志级别
     * @param message   日志消息
     * @param throwable 日志异常
     */
    public void logger(Log log, int level, String message, Throwable throwable)
    {
    }

    /**
     * 判断日志级别是否开启
     * 
     * @param log   日志对象
     * @param level 日志级别
     * @return      =true表示开启，=false表示关闭
     */
    public boolean isLoggerEnabled(Log log, int level)
    {
        return false;
    }
}
