/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 日志输出工具类
 * 1、用于Logs.info();方式直接打印日志
 * 2、用于远程或浏览器RMI/AJAX打印日志
 *
 * @version v1.0.0 @author zhichenggang 2017-7-31 新建与整理
 */
@AnAlias("Logs")
public class Logs
{
    private static final Log log = LogFactory.getLog(Logs.class);
    
    /******************************************************/
    //调试
    /******************************************************/
 
    public static void debug(Object message)
    {
        log.debug(message);
    }
    
    public static void debug(Throwable throwable)
    {
        log.debug(throwable);
    }
    
    public static void debug(Object message, Object... arguments)
    {
        log.debug(message, arguments);
    }
    
    public static void debug(Object message, Throwable throwable, Object... arguments)
    {
        log.debug(message, throwable, arguments);
    }
    
    /******************************************************/
    //信息
    /******************************************************/
    
    public static void info(Object message)
    {
        log.info(message);
    }
    
    public static void info(Throwable throwable)
    {
        log.info(throwable);
    }
    
    public static void info(Object message, Object... arguments)
    {
        log.info(message, arguments);
    }
    
    public static void info(Object message, Throwable throwable, Object... arguments)
    {
        log.info(message, throwable, arguments);
    }
    
    /******************************************************/
    //错误
    /******************************************************/
    
    public static void error(Object message)
    {
        log.error(message);
    }
    
    public static void error(Throwable throwable)
    {
        log.error(throwable);
    }
    
    public static void error(Object message, Object... arguments)
    {
        log.error(message, arguments);
    }
    
    public static void error(Object message, Throwable throwable, Object... arguments)
    {
        log.error(message, throwable, arguments);
    }
    
    /******************************************************/
    //后端警告
    /******************************************************/
    
    public static void warn(Object message)
    {
        log.warn(message);
    }
    
    public static void warn(Throwable throwable)
    {
        log.warn(throwable);
    }
    
    public static void warn(Object message, Object... arguments)
    {
        log.warn(message, arguments);
    }
    
    public static void warn(Object message, Throwable throwable, Object... arguments)
    {
        log.warn(message, throwable, arguments);
    }
    
    /******************************************************/
    //后台危急错误
    /******************************************************/
    
    public static void fatal(Object message)
    {
        log.fatal(message);
    }
    
    public static void fatal(Throwable throwable)
    {
        log.fatal(throwable);
    }
    
    public static void fatal(Object message, Object... arguments)
    {
        log.fatal(message, arguments);
    }
    
    public static void fatal(Object message, Throwable throwable, Object... arguments)
    {
        log.fatal(message, throwable, arguments);
    }
}
