/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

import org.zhiqim.kernel.util.Streams;

/**
 * HTTP/HTTPS GET访问类，把HttpURLConnection的流转化成ByteArrayInputStream，该类为非文本响应内容时使用
 *
 * @see HttpDownload 大文件下载，请使用HttpDownload替换，以防止内存使用过大
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpGetStream extends HttpClient
{
    private ByteArrayOutputStream in;
    
    public HttpGetStream(String url)
    {
        super(url, _GET_);
    }
    
    /** 重写获取HTTP结果 */
    public HttpResult getResult()
    {
        return new HttpResult(responseStatus, responseText, in==null?null:in.toByteArray());
    }
    
    /** 获取输入流 */
    public InputStream getInputStream()
    {
        return new ByteArrayInputStream(in.toByteArray());
    }
    
    /** 获取字节数组 */
    public byte[] getBytes()
    {
        return in.toByteArray();
    }
    
    protected void doReadResponseContent(HttpURLConnection conn) throws IOException
    {
        if (responseStatus == _302_FOUND_)
        {//重定向
            responseText = conn.getHeaderField("Location");
            return;
        }
        
        if (responseStatus != _200_OK_)
        {//错误
            responseText = getResponseError(conn);
            return;
        }
        
        //成功
        in = new ByteArrayOutputStream();
        try(InputStream input = conn.getInputStream())
        {
            Streams.putBytes(input, in);
        }
        
        responseText = "调用成功";
    }
}
