/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * 定义在特定场景创建List<Object>时，无需指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-11-15 新建与整理
 */
public abstract class ListO implements Iterable<Object>
{
    /***********************************************************/
    //返回List实例的方法
    /***********************************************************/
    
    /**
     * 返回对应的List实例
     * 
     * @return          List实例
     */
    public abstract List<Object> instance();
    
    /**
     * 从原来的FListO中放置所有的元素到当前FListO
     * 
     * @param list      原有FListO
     * @return          返回自身
     */
    public ListO addAll(ListO list)
    {
        instance().addAll(list.instance());
        return this;
    }
    
    /***********************************************************/
    //以为实现List的所有方法
    /***********************************************************/
    
    public int size() 
    {
        return instance().size();
    }

    public boolean isEmpty() 
    {
        return instance().isEmpty();
    }

    public boolean contains(Object o) 
    {
        return instance().contains(o);
    }
    
    public Iterator<Object> iterator() 
    {
        return instance().iterator();
    }

    public Object[] toArray() 
    {
        return instance().toArray(new Object[0]);
    }
    
    public <T> T[] toArray(T[] a) 
    {
        return instance().toArray(a);
    }
    
    public boolean add(Object e) 
    {
        return instance().add(e);
    }

    public boolean remove(Object o) 
    {
        return instance().remove(o);
    }
    
    public boolean containsAll(Collection<?> c)
    {
        return instance().containsAll(c);
    }

    public boolean addAll(Collection<?> c) 
    {
        return instance().addAll(c);
    }

    public boolean addAll(int index, Collection<?> c) 
    {
        return instance().addAll(index, c);
    }
    
    public boolean removeAll(Collection<?> c) 
    {
        return instance().removeAll(c);
    }

    public boolean retainAll(Collection<?> c) 
    {
        return instance().retainAll(c);
    }
    
    public void clear() 
    {
        instance().clear();
    }
    
    public Object get(int index) 
    {
        return instance().get(index);
    }

    public Object set(int index, Object element) 
    {
        return instance().set(index, element);
    }
    
    public void add(int index, Object element) 
    {
        instance().add(index, element);
    }

    public Object remove(int index) 
    {
        return instance().remove(index);
    }

    public int indexOf(Object o) 
    {
        return instance().indexOf(o);
    }

    public int lastIndexOf(Object o) 
    {
        return instance().lastIndexOf(o);
    }

    public ListIterator<Object> listIterator() 
    {
        return instance().listIterator();
    }

    public ListIterator<Object> listIterator(int index) 
    {
        return instance().listIterator(index);
    }

    public List<Object> subList(int fromIndex, int toIndex) 
    {
        return instance().subList(fromIndex, toIndex);
    }
    
    public String toString()
    {
        return instance().toString();
    }
}
