/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.util.Asserts;

/**
 * 定义一个LinkedHashMap<Class<?>, V>参数和结果对象，但不要求<K, V>，比Map在ZML中new时不需要指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("LinkedMapCV")
@AnNew
public class LinkedMapCV<V> extends HashMapCV<V>
{
    private final LinkedHashMap<Class<?>, V> instance;
    
    public LinkedMapCV()
    {
        instance = new LinkedHashMap<>();
    }
    
    public LinkedMapCV(int count)
    {
        instance = new LinkedHashMap<>(count);
    }
    
    public LinkedMapCV(int initialCapacity, float loadFactor, boolean accessOrder)
    {
        instance = new LinkedHashMap<>(initialCapacity, loadFactor, accessOrder);
    }
    
    public LinkedMapCV(Class<?> key, V value)
    {
        instance = new LinkedHashMap<>(1);
        instance.put(key, value);
    }
    
    public LinkedMapCV(Map<Class<?>, V> instance)
    {
        this.instance = new LinkedHashMap<>(instance);
    }
    
    public LinkedMapCV(MapCV<V> instance)
    {
        this.instance = new LinkedHashMap<>(instance.instance());
    }
    
    /***********************************************************/
    //LinkedHashMap独有的方法
    /***********************************************************/
    
    public Object[] toArray()
    {
        return instance.values().toArray();
    }
    
    public V get(int index)
    {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        
        if (index >= instance.size())
        {//索引大于等于表个数时表示超出，返回null，不抛异常
            return null;
        }
        
        Set<Entry<Class<?>, V>> entrySet = instance.entrySet();
        Iterator<Entry<Class<?>, V>> it = entrySet.iterator();
        for (int i=0;it.hasNext();i++)
        {
            Entry<Class<?>, V> entry = it.next();
            if (index > i)
                continue;
            else if (index == i)
                return entry.getValue();
            else
                break;
        }
        
        return null;
    }
}
