/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;

/**
 * 定义一个LinkedList<String>对象，在ZML中new时不需要指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("LinkedListS")
@AnNew
public class LinkedListS extends ListS
{
    private final LinkedList<String> instance;
    
    public LinkedListS()
    {
        instance = new LinkedList<>();
    }
    
    public LinkedListS(Collection<String> instance)
    {
        this.instance = new LinkedList<>(instance);
    }
    
    public LinkedListS(ListS instance)
    {
        this.instance = new LinkedList<>(instance.instance());
    }
    
    /***********************************************************/
    //实例化
    /***********************************************************/
    
    /**
     * 返回对应的List实例
     * 
     * @return          List实例
     */
    public LinkedList<String> instance()
    {
        return instance;
    }
    
    /***********************************************************/
    //私有方法
    /***********************************************************/
    
    public String getFirst() 
    {
        return instance.getFirst();
    }

    public String getLast() 
    {
        return instance.getLast();
    }

    public String removeFirst() 
    {
        return instance.removeFirst();
    }

    public String removeLast() 
    {
        return instance.removeLast();
    }
    
    public void addFirst(String e) 
    {
        instance.addFirst(e);
    }

    public void addLast(String e) 
    {
        instance.addLast(e);
    }
    
    /** @since 1.5 */
    public String peek() 
    {
        return instance.peek();
    }

    /** @since 1.5 */
    public String element() 
    {
        return instance.element();
    }

    /** @since 1.5 */
    public String poll() 
    {
        return instance.poll();
    }

    /** @since 1.5 */
    public String remove() 
    {
        return instance.remove();
    }

    /** @since 1.5 */
    public boolean offer(String e) 
    {
        return instance.offer(e);
    }

    /** @since 1.6 */
    public boolean offerFirst(String e) 
    {
        return instance.offerFirst(e);
    }

    /** @since 1.6 */
    public boolean offerLast(String e) 
    {
        return instance.offerLast(e);
    }
    
    /** @since 1.6 */
    public String peekFirst() 
    {
        return instance.peekFirst();
     }

    /** @since 1.6 */
    public String peekLast() 
    {
        return instance.peekLast();
    }

    /** @since 1.6 */
    public String pollFirst() 
    {
        return instance.pollFirst();
    }

    /** @since 1.6 */
    public String pollLast() 
    {
        return instance.pollLast();
    }

    /** @since 1.6 */
    public void push(String e) 
    {
        instance.push(e);
    }

    /** @since 1.6 */
    public String pop() 
    {
        return instance.pop();
    }

    /** @since 1.6 */
    public boolean removeFirstOccurrence(String o) {
        return instance.removeFirstOccurrence(o);
    }

    /** @since 1.6 */
    public boolean removeLastOccurrence(String o) 
    {
        return instance.removeLastOccurrence(o);
    }
    
    /** @since 1.6 */
    public Iterator<String> descendingIterator()
    {
        return instance.descendingIterator();
    }
}
