/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/**
 * 定义一个HashSet<V>抽象类，包含HashSet基本方法
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
public abstract class HashSetV<V>
{
    protected HashSet<V> instance;
    
    /***********************************************************/
    //业务使用的方法
    /***********************************************************/
    
    /**
     * 返回对应的List实例
     * 
     * @return          List实例
     */
    public HashSet<V> instance()
    {
        return instance;
    }
    
    /***********************************************************/
    //以为实现Set的所有方法
    /***********************************************************/
    
    public int size()
    {
        return instance.size();
    }

    public boolean isEmpty()
    {
        return instance.isEmpty();
    }

    public boolean contains(V o)
    {
        return instance.contains(o);
    }

    public Iterator<V> iterator()
    {
        return instance.iterator();
    }

    public boolean add(V e)
    {
        return instance.add(e);
    }

    public boolean remove(V o)
    {
        return instance.remove(o);
    }

    public boolean containsAll(Collection<V> c)
    {
        return instance.containsAll(c);
    }

    public boolean addAll(Collection<V> c)
    {
        return instance.addAll(c);
    }

    public boolean retainAll(Collection<V> c)
    {
        return instance.retainAll(c);
    }

    public boolean removeAll(Collection<V> c)
    {
        return instance.removeAll(c);
    }

    public void clear()
    {
        instance.clear();
    }
    
    public String toString()
    {
        return instance.toString();
    }
}
