/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.HashSet;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;

/**
 * 定义一个HashSet<Object>对象，在ZML中new时不需要指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("HashSetO")
@AnNew
public class HashSetO extends HashSetV<Object>
{
    public HashSetO()
    {
        instance = new HashSet<>();
    }
    
    public HashSetO(int count)
    {
        instance = new HashSet<>(count);
    }
    
    public HashSetO(Object s)
    {
        instance = new HashSet<>(1);
        instance.add(s);
    }
    
    public HashSetO(Collection<?> instance)
    {
        this.instance = new HashSet<>(instance);
    }
    
    public HashSetO(HashSetO instance)
    {
        this.instance = new HashSet<>(instance.instance());
    }
    
    /***********************************************************/
    //业务使用的方法
    /***********************************************************/
    
    public HashSetO addAll(HashSetO set)
    {
        instance.addAll(set.instance());
        return this;
    }

    public Object[] toArray()
    {
        return instance.toArray();
    }

    public <T> T[] toArray(T[] a)
    {
        return instance.toArray(a);
    }
}
