/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

import java.util.List;

/**
 * 处理器适配成可执行对象，以便在Threader中处理时转换成Handler中处理
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
class Eventee<E> implements Runnable
{
    private E event;
    private List<Eventer<E>> eventerList;
    
    public Eventee(E event, List<Eventer<E>> eventerList)
    {
        this.event = event;
        this.eventerList = eventerList;
    }
    
    public void run()
    {
        for (Eventer<E> eventer : eventerList)
        {//按注册顺序冒泡处理
            if (!eventer.process(event))
                break;
        }
    }

    public E getEvent()
    {
        return event;
    }

    public List<Eventer<E>> getEventerList()
    {
        return eventerList;
    }
    
    public int hasCode()
    {
        return event.hashCode();
    }
    
    public boolean equals(Object obj) 
    {
        if (obj == null)
            return false;
        
        if (!(obj instanceof Eventee<?>))
            return false;
        
        Eventee<?> other = (Eventee<?>)obj;
        if (other.event == null)
            return this.event == null;
        else
            return (other.event.equals(this.event));
    }
    
    public String toString()
    {
        return event.toString();
    }
}
