/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 类型常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("TypeConstants")
public interface TypeConstants
{
    //基本类型和基本类型数组哈稀码
    public int BOOLEAN_CODE            = 64711720;//boolean.class.getName().hasCode()
    public int BYTE_CODE               = 3039496;//byte.class.getName().hasCode()
    public int CHAR_CODE               = 3052374;//char.class.getName().hasCode()
    public int SHORT_CODE              = 109413500;//short.class.getName().hasCode()
    public int INT_CODE                = 104431;//int.class.getName().hasCode()
    public int LONG_CODE               = 3327612;//long.class.getName().hasCode()
    public int FLOAT_CODE              = 97526364;//float.class.getName().hasCode()
    public int DOUBLE_CODE             = -1325958191;//double.class.getName().hasCode()

    public int BOOLEAN_OBJ_CODE        = 344809556;//Boolean.class.getName().hasCode()
    public int BYTE_OBJ_CODE           = 398507100;//Byte.class.getName().hasCode()
    public int CHAR_OBJ_CODE           = 155276373;//Character.class.getName().hasCode()
    public int SHORT_OBJ_CODE          = -515992664;//Short.class.getName().hasCode()
    public int INT_OBJ_CODE            = -2056817302;//Integer.class.getName().hasCode()
    public int LONG_OBJ_CODE           = 398795216;//Long.class.getName().hasCode()
    public int FLOAT_OBJ_CODE          = 527879800;//Float.class.getName().hasCode()
    public int DOUBLE_OBJ_CODE         = 761287205;//Double.class.getName().hasCode()
    
    public int BOOLEAN_ARR_CODE        = 2911;//boolean[].class.getName().hasCode()
    public int BYTE_ARR_CODE           = 2887;//byte[].class.getName().hasCode()
    public int CHAR_ARR_CODE           = 2888;//char[].class.getName().hasCode()
    public int SHORT_ARR_CODE          = 2904;//short[].class.getName().hasCode()
    public int INT_ARR_CODE            = 2894;//int[].class.getName().hasCode()
    public int LONG_ARR_CODE           = 2895;//long[].class.getName().hasCode()
    public int FLOAT_ARR_CODE          = 2891;//float[].class.getName().hasCode()
    public int DOUBLE_ARR_CODE         = 2889;//double[].class.getName().hasCode()
    
    public int BOOLEAN_OBJ_ARR_CODE    = -499457160;//Boolean[].class.getName().hasCode()
    public int BYTE_OBJ_ARR_CODE       = -2079942674;//Byte[].class.getName().hasCode()
    public int CHAR_OBJ_ARR_CODE       = -1378128041;//Character[].class.getName().hasCode()
    public int SHORT_OBJ_ARR_CODE      = 417147620;//Short[].class.getName().hasCode()
    public int INT_OBJ_ARR_CODE        = -1935445726;//Integer[].class.getName().hasCode()
    public int LONG_OBJ_ARR_CODE       = -2071011078;//Long[].class.getName().hasCode()
    public int FLOAT_OBJ_ARR_CODE      = 48646404;//Float[].class.getName().hasCode()
    public int DOUBLE_OBJ_ARR_CODE     = -175516795;//Double[].class.getName().hasCode()
    
    //字符串和字符串数组哈稀码
    public int STRING_CODE             = 1195259493;//String.class.getName().hasCode()
    public int STRING_ARR_CODE         = 392722245;//String[].class.getName().hasCode()
    
    //数据库时间哈稀码
    public int TIMESTAMP_CODE          = 1252880906;//Timestamp.class.getName().hashCode()
}
