/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import java.nio.charset.Charset;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 
 * 编码常量定义，包括字符集编码、签名、编解码等
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("CodeConstants")
public interface CodeConstants extends SignConstants
{
    public String _UTF_8_              = "UTF-8";//BOM EF BB BF
    public Charset _UTF_8_C_           = Charset.forName(_UTF_8_);
    
    public String _GBK_                = "GBK";
    public Charset _GBK_C_             = Charset.forName(_GBK_);
    
    //Unicode下的编码
    public String _UTF_16_             = "UTF-16";//无指BOM由字节自行检查
    public String _UTF_16LE_           = "UTF-16LE";//BOM FF FE
    public String _UTF_16BE_           = "UTF-16BE";//BOM FE FF
    public String _UTF_32_             = "UTF-32";//无指定BOM由字节自行检查
    public String _UTF_32LE_           = "UTF-32LE";//BOM FF FE 00 00
    public String _UTF_32BE_           = "UTF-32BE";//BOM 00 00 FE FF
    
    public Charset _UTF_16BE_C_        = Charset.forName(_UTF_16BE_);
    
    //ANSI下的本地语言
    public String _ISO_8859_1_         = "ISO-8859-1";
    public String _GB2312_             = "GB2312";
    
    //编解码
    public String _HEX_                = "HEX";
    public String _BASE64_             = "Base64";
    public String _MD5_                = "MD5";
    public String _SHA1_               = "SHA1";
    public String _SHA256_             = "SHA-256";
    public String _RSA_                = "RSA";
    
    public String _HMAC_MD5_           = "HmacMD5";
    public String _HMAC_SHA1_          = "HmacSHA1";  
    public String _HMAC_SHA256_        = "HmacSHA256";  
    public String _HMAC_SHA384_        = "HmacSHA384";
    public String _HMAC_SHA512_        = "HmacSHA512";
    
    //BASE64标准64个字符，和支持的填充字符（等号和回车换行）
    public String _BASE64_STD_         = _LETTERS_DIGITS_ + "+/";
    public String _BASE64_EXT_         = _LETTERS_DIGITS_ + "+/=\r\n";
    public byte[] _BASE64_BS_          = _BASE64_STD_.getBytes();//64个BASE64字符
    public byte   _BASE64_PAD_         = (byte)'=';//不足8的倍数填充符
}
