/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.config;

import java.io.IOException;
import java.io.InputStream;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.util.Resources;

/**
 * 工程参数配置类的DTD本地验证，加载包内的文件(zhiqim_config_1_5_0.dtd)，这样则不要到zhiqim.org下载验证 <br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27  新建与整理
 * @version v1.3.0 @author zouzhigang 2017-2-27  修改为1.3.0.dtd
 * @version v1.4.0 @author zouzhigang 2017-11-20 修改为1.4.0.dtd
 * @version v1.4.1 @author zouzhigang 2018-4-20  修改为1.4.1.dtd
 * @version v1.5.0 @author zouzhigang 2018-8-15  修改为1.5.0.dtd
 */
public class ConfigResolver implements EntityResolver, ZhiqimConstants
{
    private String path;
    
    public ConfigResolver(String path)
    {
        this.path = path;
    }
    
    /**
     * 实现验证流
     * 
     * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String, java.lang.String)
     */
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException 
    {
        if (!Z_CONFIG_DTD_PUBLIC_ID.equals(publicId))
        {//版本不支持
            throw new SAXException("配置文件["+path+"]格式不正确，["+Z_VERSION+"]仅支持["+Z_CONFIG_DTD_PUBLIC_ID+"]格式");
        }
        
        InputStream stream = Resources.getResourceStream(ConfigResolver.class, Z_CONFIG_DTD_PATH);
        return new InputSource(stream);
    }
}
