/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Threads;

/**
 * 知启蒙工程监听类 ，由FCommand发起的命令在这里执行
 * 
 * 1. -s表示启动
 * 2. -c表示工程退出
 * 3. -i表示查看信息
 * 4. -t表示测试配置文件（TODO 暂未实现）
 * 5. -r表示重新加载配置（TODO 暂未实现）
 * 6. -h表示帮助
 * 7. -?表示帮助
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
final class ZhiqimMonitor extends Threadx implements ZhiqimConstants, SignConstants
{
    private static final Log logger = LogFactory.getLog(ZhiqimMonitor.class);
    
    private ServerSocket serverSocket;
    private int port;
    
    //只允许包创建实例
    ZhiqimMonitor(int port)
    {
        this.port = port;
    }
    
    /** 线程名 */
    protected String getThreadName()
    {
        return "ZhiqimMonitor";
    }
    
    /**********************************************************************************/
    //开启&关闭&循环运行
    /**********************************************************************************/
    
    /** 开启 */
    protected boolean openBefore()
    {
        try
        {
            serverSocket = new ServerSocket(port, 5, InetAddress.getByName("127.0.0.1"));
            serverSocket.setReuseAddress(true);
            return true;
        }
        catch (BindException e)
        {
            logger.error("启动监视线程失败，工程已启动或端口[boot.port]被占用");
            return false;
        }
        catch (Exception e)
        {
            logger.error("启动监视线程失败", e);
            return false;
        }
    }
    
    /** 关闭 */
    protected void closeAfter()
    {
        Threads.closeIgnoreException(serverSocket);
    }
    
    /** 运行 */
    public void loop()
    {
        Socket socket = null;String cmd = null;
        try
        {
            socket = serverSocket.accept();
            
            LineNumberReader line = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
            String lineKey = line.readLine();
            if (!Z_NAME.equals(lineKey))
                return;
            
            cmd = line.readLine();
            if (Z_INFO_C.equals(cmd))
            {//查看信息
                StringBuilder strb = new StringBuilder()
                    .append("响应结果:").append(_BR_)
                    .append("PID:").append(Systems.getPid()).append(_BR_);
                
                socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                socket.getOutputStream().flush();
            }
            else if (Z_TEST_C.equals(cmd) || Z_RELOAD_C.equals(cmd))
            {//测试配置文件和重新加载配置文件 TODO 暂未实现
                StringBuilder strb = new StringBuilder()
                    .append("响应结果:").append(_BR_)
                    .append("暂未实现").append(_BR_);
                
                socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                socket.getOutputStream().flush();
            }
            else if (Z_HELP_C.equals(cmd) || Z_QUESTION_C.equals(cmd))
            {//帮助
                StringBuilder strb = new StringBuilder()
                    .append("响应结果:").append(_BR_)
                    .append("-s    启动工程").append(_BR_)
                    .append("-c    关闭工程").append(_BR_)
                    .append("-i    查看信息").append(_BR_)
                    .append("-t    测试配置文件").append(_BR_)
                    .append("-r    重新加载配置").append(_BR_)
                    .append("-h    帮助").append(_BR_)
                    .append("-?    帮助").append(_BR_);
                
                socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                socket.getOutputStream().flush();
            }
        }
        catch(Exception e)
        {
            logger.error(e);
        }
        finally
        {
            Threads.closeIgnoreException(socket);
            if (Z_CLOSE_C.equals(cmd))
            {//接受到退出工程命令
                closeNotInterrupt();
                System.exit(0);
            }
        }
    }
}
