/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.xml.parser;

import java.lang.reflect.Field;
import java.util.List;
import org.w3c.dom.Node;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.util.Annotations;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xml;
import org.zhiqim.kernel.xml.XmlParser;
import org.zhiqim.kernel.xml.XmlTag;
import org.zhiqim.kernel.xml.Xmls;

public class ObjectParser
implements XmlParser {
    private Xml xmlMain;

    @Override
    public XmlParser set(Xml xmlMain) {
        this.xmlMain = xmlMain;
        return this;
    }

    @Override
    public String toStringInner(Object obj, String tagName, int tagLevel) {
        Class<?> clazz = obj.getClass();
        if (tagName == null && obj instanceof XmlTag) {
            tagName = ((XmlTag)obj).getXmlTag();
        }
        if (tagName == null) {
            tagName = Xmls.getXmlClassTag(clazz);
        }
        Asserts.as(Validates.isNotEmptyBlank(tagName) ? null : "\u5bf9\u8c61\u8f6cXML\u65f6\u672a\u5b9a\u4e49XmlClassTag");
        StringBuilder strb = new StringBuilder();
        Strings.addNewLine(strb);
        Strings.addTwoSpace(strb, tagLevel);
        Xmls.addTagBegin(strb, tagName);
        List<Field> fieldList = Classes.getFieldListDeep(clazz);
        for (Field field : fieldList) {
            String name = Annotations.getFieldName(field);
            Object value = Classes.getFieldValue(obj, field);
            if (value == null) continue;
            boolean hasGroup = Xmls.hasXmlFieldGroup(field);
            strb.append(this.xmlMain.toStringInner(value, hasGroup ? name : null, hasGroup ? tagLevel + 1 : tagLevel));
        }
        Strings.addNewLine(strb);
        Strings.addTwoSpace(strb, tagLevel);
        Xmls.addTagEnd(strb, tagName);
        return strb.toString();
    }

    @Override
    public Object toObjectInner(Node node, Class<?> cls, Class<?> generics) {
        String tag = Xmls.getXmlClassTag(cls);
        if (!Xmls.isOwn(node, tag)) {
            return null;
        }
        Object obj = Classes.newInstance(cls);
        Asserts.assertNotNull(obj, ZhiqimI18n.classDoesNotSupportNoParameterConstructors);
        List<Field> fieldList = Classes.getFieldListDeep(cls);
        for (Field field : fieldList) {
            Class<?> fieldClass = field.getType();
            String fieldName = Annotations.getFieldName(field);
            Class<?> fieldGenerics = Annotations.getGenericsClass(field);
            Node fieldNode = Xmls.hasXmlFieldGroup(field) ? Xmls.getNode(node, fieldName) : node;
            Object value = this.xmlMain.toObjectInner(fieldNode, fieldClass, fieldGenerics);
            Classes.setFieldValue(obj, field, value);
        }
        return obj;
    }
}

