/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    private MessageDigest digest;
    private long length;

    public DigestOutputStream(OutputStream stream, MessageDigest digest) {
        super(stream);
        this.digest = digest;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.digest.update((byte)b);
        ++this.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.digest.update(b, off, len);
        this.length += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.digest.update(b);
        this.length += (long)b.length;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public byte[] digest() {
        return this.digest.digest();
    }

    public long length() {
        return this.length;
    }

    public String toString() {
        return "[DigestOutputStream] " + this.digest.toString();
    }
}

