/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.seqs;

import java.io.RandomAccessFile;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.RAFiles;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.seqs.Sequence;

public class SequenceFile
extends Sequence
implements CodeConstants {
    private final boolean auto;
    private final String filePath;
    private final RandomAccessFile file;
    private final boolean isValid;

    public SequenceFile(String filePath) {
        this(1L, Integer.MAX_VALUE, 10, 1L, filePath, true);
    }

    public SequenceFile(int len, String filePath) {
        this(1L, Ints.getMaxInt(len), len, 1L, filePath, true);
    }

    public SequenceFile(long min, long max, String filePath) {
        this(min, max, Longs.length(max), min, filePath, true);
    }

    public SequenceFile(long min, long max, long seq, String filePath) {
        this(min, max, Longs.length(max), seq, filePath, true);
    }

    public SequenceFile(String filePath, boolean auto) {
        this(1L, Integer.MAX_VALUE, 10, 1L, filePath, auto);
    }

    public SequenceFile(int len, String filePath, boolean auto) {
        this(1L, Ints.getMaxInt(len), len, 1L, filePath, auto);
    }

    public SequenceFile(long min, long max, String filePath, boolean auto) {
        this(min, max, Longs.length(max), min, filePath, auto);
    }

    public SequenceFile(long min, long max, long seq, String filePath, boolean auto) {
        this(min, max, Longs.length(max), seq, filePath, auto);
    }

    protected SequenceFile(long min, long max, int len, long seq, String filePath, boolean auto) {
        super(min, max, len, seq);
        this.filePath = filePath;
        this.auto = auto;
        String fileDir = Files.getFileDir(filePath);
        if (!Files.mkDirectory(fileDir)) {
            this.file = null;
            this.isValid = false;
        } else {
            this.file = RAFiles.newFileRW(this.filePath);
            if (auto) {
                this.load();
            }
            this.isValid = true;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected String readFile() {
        return Files.readUTF8(this.filePath);
    }

    protected void writeFile(String str) {
        RAFiles.writeUTF8(this.file, 0L, str);
    }

    public SequenceFile load() {
        if (!Files.isFile(this.filePath)) {
            return this;
        }
        String seq = Strings.trim(this.readFile());
        if (!Validates.isIntegerPositive(seq)) {
            return this;
        }
        this.setSequence(Longs.toLong(seq));
        return this;
    }

    public void save() {
        this.writeFile(Strings.suffixLen(this.sequence, 19, ' '));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        if (!this.isValid) {
            throw Asserts.exception("\u521b\u5efaSequenceFile\u5931\u8d25\uff0c\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\u4e14\u521b\u5efa\u5931\u8d25");
        }
        if (!this.auto) {
            return super.next();
        }
        SequenceFile sequenceFile = this;
        synchronized (sequenceFile) {
            this.chkSequence();
            long seq = this.sequence++;
            this.save();
            return seq;
        }
    }
}

