/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.MD5;

public class HMAC
implements CodeConstants {
    public static String signatureUTF8_SHA1_BASE64(String data, String key) {
        try {
            return HMAC.signature(data.getBytes("UTF-8"), key.getBytes("UTF-8"), "HmacSHA1", "Base64");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] signatureUTF8_SHA1(String data, String key) {
        try {
            return HMAC.signature(data.getBytes("UTF-8"), key.getBytes("UTF-8"), "HmacSHA1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String signature(byte[] data, byte[] key, String keyCoding, String retCoding) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] bytes = HMAC.signature(data, key, keyCoding);
        if ("HEX".equals(retCoding)) {
            return Hexs.toHexString(bytes);
        }
        if ("Base64".equals(retCoding)) {
            return Base64.encode(bytes);
        }
        if ("MD5".equals(retCoding)) {
            return MD5.encode(bytes);
        }
        throw Asserts.exception("\u4e0d\u652f\u6301\u7684retCoding");
    }

    public static byte[] signature(byte[] data, byte[] key, String keyCoding) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec secretKey = new SecretKeySpec(key, keyCoding);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }
}

