/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.tree;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.annotation.AnNonnull;
import org.zhiqim.kernel.tree.Treer;

public class Tree<E> {
    private final Treer<E> treer;
    private final E self;
    private final Tree<E> parent;
    private final List<Tree<E>> children;
    private final boolean isLastNode;

    public Tree(E root, Treer<E> treer) {
        this.self = root;
        this.treer = treer;
        this.parent = null;
        this.children = new ArrayList<Tree<E>>();
        this.isLastNode = true;
    }

    private Tree(E self, Tree<E> parent, boolean isLastNode) {
        this.self = self;
        this.parent = parent;
        this.treer = parent.treer;
        this.children = new ArrayList<Tree<E>>();
        this.isLastNode = isLastNode;
    }

    public Tree<E> build(List<E> list) {
        ArrayList<E> cList = new ArrayList<E>();
        for (E item : list) {
            if (!this.treer.isChildNode(this.self, item)) continue;
            cList.add(item);
        }
        int size = cList.size();
        int i = 0;
        while (i < size) {
            Tree<E> child = new Tree<E>(cList.get(i), this, i == size - 1);
            child.build(list);
            this.children.add(child);
            ++i;
        }
        return this;
    }

    @AnNonnull
    public E self() {
        return this.self;
    }

    @AnNonnull
    public List<Tree<E>> children() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasNextNode() {
        return !this.isLastNode;
    }

    public boolean isLastNode() {
        return this.isLastNode;
    }

    public boolean isLastNode(int level) {
        Tree<E> tree = this;
        int i = 0;
        while (i < level) {
            tree = tree.parent;
            ++i;
        }
        return tree.isLastNode;
    }

    public int size() {
        int size = 1;
        for (Tree<E> tree : this.children) {
            size += tree.size();
        }
        return size;
    }
}

