/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.logger;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.logging.Logger;

public class ConsoleLogger
implements Logger {
    private String pattern;
    private int levelMin;
    private int levelMax;

    public ConsoleLogger(String pattern, int levelMin, int levelMax) {
        this.pattern = pattern;
        this.levelMin = levelMin;
        this.levelMax = levelMax;
    }

    @Override
    public void logger(Log log, int level, String message, Throwable throwable) {
        if (level < this.levelMin || level > this.levelMax) {
            return;
        }
        if (message != null) {
            message = LogFactory.format(this.pattern, message, LogFactory.getLevel(level));
            System.out.print(message);
        }
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public boolean isLoggerEnabled(Log log, int level) {
        return level >= this.levelMin && level <= this.levelMax;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getLevelMin() {
        return this.levelMin;
    }

    public void setLevelMin(int levelMin) {
        this.levelMin = levelMin;
    }

    public int getLevelMax() {
        return this.levelMax;
    }

    public void setLevelMax(int levelMax) {
        this.levelMax = levelMax;
    }
}

