/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json.parser;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Validates;

public class ArrayParser
implements JsonParser {
    private Json jsonMain;

    @Override
    public JsonParser set(Json jsonMain) {
        this.jsonMain = jsonMain;
        return this;
    }

    @Override
    public String toString(Object obj) {
        Object[] objs = Arrays.toArray(obj);
        StringBuilder strb = new StringBuilder("[");
        int i = 0;
        while (i < objs.length) {
            Object o = objs[i];
            if (i > 0) {
                strb.append(",").append(this.jsonMain.toString(o));
            } else {
                strb.append(this.jsonMain.toString(o));
            }
            ++i;
        }
        strb.append("]");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls) {
        List<String> jList = ArrayParser.toFieldList(json);
        if (cls == boolean[].class) {
            return ArrayParser.fromJsonBoolean(jList);
        }
        if (cls == Boolean[].class) {
            return ArrayParser.fromJsonBooleanObj(jList);
        }
        if (cls == byte[].class) {
            return ArrayParser.fromJsonByte(jList);
        }
        if (cls == Byte[].class) {
            return ArrayParser.fromJsonByteObj(jList);
        }
        if (cls == char[].class) {
            return ArrayParser.fromJsonChar(jList);
        }
        if (cls == Character[].class) {
            return ArrayParser.fromJsonCharObj(jList);
        }
        if (cls == short[].class) {
            return ArrayParser.fromJsonShort(jList);
        }
        if (cls == Short[].class) {
            return ArrayParser.fromJsonShortObj(jList);
        }
        if (cls == int[].class) {
            return ArrayParser.fromJsonInt(jList);
        }
        if (cls == Integer[].class) {
            return ArrayParser.fromJsonIntObj(jList);
        }
        if (cls == long[].class) {
            return ArrayParser.fromJsonLong(jList);
        }
        if (cls == Long[].class) {
            return ArrayParser.fromJsonLongObj(jList);
        }
        if (cls == float[].class) {
            return ArrayParser.fromJsonFloat(jList);
        }
        if (cls == Float[].class) {
            return ArrayParser.fromJsonFloatObj(jList);
        }
        if (cls == double[].class) {
            return ArrayParser.fromJsonDouble(jList);
        }
        if (cls == Double[].class) {
            return ArrayParser.fromJsonDoubleObj(jList);
        }
        if (cls == String[].class) {
            return ArrayParser.fromJsonString(jList);
        }
        Class<?> type = cls.getComponentType();
        Object[] objs = (Object[])Array.newInstance(type, jList.size());
        int i = 0;
        while (i < jList.size()) {
            objs[i] = this.jsonMain.toObject(jList.get(i), type, false);
            ++i;
        }
        return objs;
    }

    public static boolean[] fromJsonBoolean(List<String> jList) {
        boolean[] val = new boolean[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Boolean.parseBoolean(v);
            ++i;
        }
        return val;
    }

    public static Boolean[] fromJsonBooleanObj(List<String> jList) {
        Boolean[] val = new Boolean[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Boolean.parseBoolean(v);
            ++i;
        }
        return val;
    }

    public static byte[] fromJsonByte(List<String> jList) {
        byte[] val = new byte[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Byte.parseByte(v);
            ++i;
        }
        return val;
    }

    public static Byte[] fromJsonByteObj(List<String> jList) {
        Byte[] val = new Byte[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Byte.parseByte(v);
            ++i;
        }
        return val;
    }

    public static char[] fromJsonChar(List<String> jList) {
        char[] val = new char[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = v.charAt(0);
            ++i;
        }
        return val;
    }

    public static Character[] fromJsonCharObj(List<String> jList) {
        Character[] val = new Character[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Character.valueOf(v.charAt(0));
            ++i;
        }
        return val;
    }

    public static short[] fromJsonShort(List<String> jList) {
        short[] val = new short[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Short.parseShort(v);
            ++i;
        }
        return val;
    }

    public static Short[] fromJsonShortObj(List<String> jList) {
        Short[] val = new Short[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Short.parseShort(v);
            ++i;
        }
        return val;
    }

    public static int[] fromJsonInt(List<String> jList) {
        int[] val = new int[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Ints.toInt(v);
            ++i;
        }
        return val;
    }

    public static Integer[] fromJsonIntObj(List<String> jList) {
        Integer[] val = new Integer[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Ints.toInt(v);
            ++i;
        }
        return val;
    }

    public static long[] fromJsonLong(List<String> jList) {
        long[] val = new long[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Longs.toLong(v);
            ++i;
        }
        return val;
    }

    public static Long[] fromJsonLongObj(List<String> jList) {
        Long[] val = new Long[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Longs.toLong(v);
            ++i;
        }
        return val;
    }

    public static float[] fromJsonFloat(List<String> jList) {
        float[] val = new float[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Float.parseFloat(v);
            ++i;
        }
        return val;
    }

    public static Float[] fromJsonFloatObj(List<String> jList) {
        Float[] val = new Float[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Float.valueOf(Float.parseFloat(v));
            ++i;
        }
        return val;
    }

    public static double[] fromJsonDouble(List<String> jList) {
        double[] val = new double[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Double.parseDouble(v);
            ++i;
        }
        return val;
    }

    public static Double[] fromJsonDoubleObj(List<String> jList) {
        Double[] val = new Double[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Double.parseDouble(v);
            ++i;
        }
        return val;
    }

    public static String[] fromJsonString(List<String> jList) {
        String[] val = new String[jList.size()];
        int i = 0;
        while (i < val.length) {
            String v = Jsons.removeStartEndQuotation(jList.get(i));
            val[i] = Jsons.removeEscapeChar(v);
            ++i;
        }
        return val;
    }

    public static List<String> toFieldList(String json) {
        if (Validates.isEmptyBlank(json)) {
            return new ArrayList<String>();
        }
        if (!json.startsWith("[") || !json.endsWith("]")) {
            return new ArrayList<String>();
        }
        json = json.substring(1, json.length() - 1);
        return Jsons.getFieldList(json);
    }
}

