/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zhiqim.kernel.control.Eventee;
import org.zhiqim.kernel.control.Eventer;
import org.zhiqim.kernel.control.ThreaderController;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.MapCV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Randoms;

public class EventerController
extends ThreaderController {
    private static final Log log = LogFactory.getLog(EventerController.class);
    private final MapCV<List<Eventer<?>>> eventerMap = new HashMapCV();

    public EventerController() {
        this.setThreadName("Eventer-" + Randoms.upperLetters(1) + Randoms.lowerLettersDigits(3));
    }

    @Override
    public void closeAfter() {
        super.closeAfter();
        this.eventerMap.clear();
    }

    public void addEventer(Eventer<?> eventer) {
        Class<?> clazz = eventer.clazz();
        List<Eventer<?>> list = this.eventerMap.get(clazz);
        if (list == null) {
            list = new ArrayList();
            this.eventerMap.put(clazz, list);
        }
        list.add(eventer);
    }

    public void removeEventer(Eventer<?> eventer) {
        Class<?> clazz = eventer.clazz();
        List<Eventer<?>> list = this.eventerMap.get(clazz);
        if (list == null) {
            return;
        }
        Iterator<Eventer<?>> it = list.iterator();
        while (it.hasNext()) {
            Eventer<?> item = it.next();
            if (item.getClass() != eventer.getClass()) continue;
            it.remove();
        }
        if (list.isEmpty()) {
            this.eventerMap.remove(clazz);
        }
    }

    public boolean execute(Object event) {
        return this.execute(event, false);
    }

    public boolean execute(Object event, boolean priority) {
        List eventer = this.eventerMap.get(event.getClass());
        if (eventer == null) {
            log.fatal((Object)"\u4e8b\u4ef6\u5904\u7406\u5668[%s]\u672a\u914d\u7f6e\u5904\u7406\u5668", event.getClass().getName());
            return false;
        }
        Eventee<Object> command = new Eventee<Object>(event, eventer);
        return super.execute(command, priority);
    }
}

