/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.ZulBootstrap;
import org.zhiqim.uploadlarge.dbo.UpllChunk;

/**
 * 文件碎片列表
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FileChunkListAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {        
        request.setResponsePrivateCache();
        int pageNo = request.getParameterInt("page", 1);
        int pageSize = 10;
        
        String fileName = request.getParameter("fileName");
        String fileExt = request.getParameter("fileExt");
        String chunkBeginDate = request.getParameter("chunkBeginDate");
        String chunkEndDate = request.getParameter("fileBeginDate");
        
        Selector sel = new Selector();
        sel.addReplace("id", request.getNestAttributeString(ORM.Z_ORM_ID));
        sel.addMaybeLike("fileName", fileName);
        if(Validates.isNotEmpty(chunkBeginDate))
            sel.addMaybeThenGE("chunkTime", chunkBeginDate + " 00:00:00");
        if(Validates.isNotEmpty(chunkEndDate))
            sel.addMaybeThenLE("chunkTime", chunkEndDate + " 23:59:59");
        sel.addMaybe("fileExt", fileExt);
        sel.addOrderbyDesc("chunkTime");
        
        PageResult<UpllChunk> result = ZulBootstrap.table(request).page(UpllChunk.class, pageNo, pageSize,sel);
        result.addConditionMap(request.getParameterMap());
        
        request.setAttribute("result", result);
    }
}
