/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ServiceExecutor;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.schedule.Day;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;

/**
 * 大文件上传引导类
 *
 * @version v1.0.0 @author zouzhigang 2018-11-23 新建与整理
 */
public class ZulBootstrap extends ZmlBootstrap implements ZulConstants
{
    private Scheduler scheduler;
    private Day day;
    
    /*******************************************************************************/
    //静态传入request获取属性
    /*******************************************************************************/
    
    /** 获取数据库表指令类 */
    public static ZTable table(HttpRequest request)
    {
        return ORM.table(request.getContextAttributeString(_SERV_UPLOAD_LARGE_ORM_, request.getConfiguration()));
    }
    
    /** 获取数据库表指令类 */
    public static ZTable table(HttpContext context)
    {
        return ORM.table(context.getAttributeString(_SERV_UPLOAD_LARGE_ORM_, context.getConfiguration()));
    }
    
    /*******************************************************************************/
    //初始化&销毁
    /*******************************************************************************/
    
    @Override
    public void initBefore() throws Exception
    {
        //1.在配置加载之后,把/service/uploadlarge和/service/upll/*加到服务中
        ServiceExecutor executor = context.getServiceExecutor();
        executor.addService(_PATH_SERVICE_UPLOAD_LARGE_, new ZulService());
        executor.addService(_PATH_SERVICE_UPLOAD_LARGE_ACCESS_, new ZulAccessService());
        
        //2.增加定时任务清理上传文件碎片表
        day = new Day(new ZulTask(context), 5, 7, 7);
        scheduler = Global.getWithoutNew(Scheduler.class);
        scheduler.addTask(day);
    }
    
    @Override
    public void destroy()
    {
        scheduler.removeTask(day);
    }
}
