/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.ui;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpUploader;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class ZuiUploadByFormAction
implements Action,
HttpdConstants {
    private static final Log log = LogFactory.getLog(ZuiUploadByFormAction.class);

    public void execute(HttpRequest request) throws Exception {
        String sessionName = Strings.toString((Object)request.getSessionName(), (String)"guest");
        String rootDir = request.getContextAttributeString("upload.rootDir");
        if (Validates.isEmptyBlank((String)rootDir) || !Files.mkDirectory((String)rootDir)) {
            log.error((Object)"[UploadAccessService][%s][\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55][%s]", new Object[]{sessionName, "upload.rootDir"});
            request.returnHistory("\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55");
            return;
        }
        try (HttpUploader uploader = new HttpUploader();){
            uploader.parseHttpRequest(request, 0x200000);
            String fileExt = uploader.getFileExt();
            if (Validates.isEmpty((String)fileExt)) {
                request.setAlertMsg("\u4ec5\u652f\u6301\u538b\u7f29\u6587\u4ef6\u5305\u4e0a\u4f20\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return;
            }
            try {
                rootDir = Strings.removeEndsWith((String)Files.toLinuxPath((String)rootDir), (String)"/");
                String filePath = String.valueOf(rootDir) + "/tutorial/" + Ids.uuid() + "." + fileExt;
                uploader.writeToFile(filePath);
                request.setAlertMsg("\u4e0a\u4f20\u6210\u529f");
            }
            catch (Exception exception) {
                request.setAlertMsg("\u4e0a\u4f20\u5931\u8d25");
            }
        }
    }
}

