/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.statement;

import java.util.Iterator;
import java.util.List;

import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Break.BreakException;
import org.zhiqim.zml.statement._Continue.ContinueException;

/**
 * 迭代语句，格式为：<#for item : list></#for>或<#for (item : list)></#for>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _For extends Statement implements StatementNesting
{
    private String itemVariableName;
    private Expression _expression;
    private List<Statement> stmtList;
    private boolean isBeginExclusiveLine = false;
    
    private transient String content;
    private transient int contentBeginIndex;
    
    @Override
    public boolean isNesting()
    {
        return true;
    }
    
    @Override
    public boolean isExclusiveLine() throws StatementException
    {
        return super.isExclusiveLine()?isBeginExclusiveLine:false;
    }
    
    @Override
    public void parseStatement() throws StatementException
    {
        String s = Strings.trim(getStatement(), FOR_BEGIN, FOR_END);
        int ind = s.indexOf(TAG_END);
        if (ind == -1)
            throw new StatementException(this, FOR + "未找到单行结束符");

        String forEach = s.substring(0, ind).trim();
        if (forEach.startsWith("("))
        {//有(开头，则认为格式为for (item : list)
            forEach = Strings.trim(forEach, "(", ")").trim();
        }
        //支持格式for (var item : list)格式，去除var定义
        forEach = Strings.trimLeft(forEach, "var ").trim();
        int index = forEach.indexOf(FOR_SEPARATOR);
        if (index == -1)
            throw new StatementException(this, FOR + "未找到节点定义符");
        
        //变量
        itemVariableName = forEach.substring(0, index).trim();
        
        try
        {
            String expression = forEach.substring(index + FOR_SEPARATOR.length()).trim();
            _expression = ExpressionParser.parseExpression(expression);
        }
        catch(Exception e)
        {
            throw new StatementException(this, FOR + e.getMessage());
        }
        
        //对_for内的内容进行嵌套检查，得到嵌套语句列表
        content = s.substring(ind + 1);
        int brNum = Strings.getStartsWithBrNum(content);
        if (brNum > 0)
        {//删除<#for item : list>之后的首个\r\n
            content = content.substring(brNum);
        }
        
        isBeginExclusiveLine = brNum > 0;
        contentBeginIndex = getBeginIndex() + FOR_BEGIN.length() + ind + 1 + brNum;
        
        //删除</#for>之前的\r\n之后的空白
        content = Strings.removeRightMaybeEmptyBlank(content);
        
        stmtList = StatementParser.parseStatementNesting(this);
        content = null;//清除临时数据
    }
    
    @Override
    public String process(ZmlVariable variableMap) throws StatementException
    {
        Object value = null;
        
        try
        {
            value = _expression.build(variableMap);
        }
        catch(Exception e)
        {
            throw new StatementException(this, FOR + e.getMessage(), e);
        }
        
        if (value == null)
            return null;//无变量，直接返回null
        
        if (!(value instanceof Iterator) && !(value instanceof Iterable) && !value.getClass().isArray())
            throw new StatementException(this, FOR + "对象不支持迭代");
        
        try
        {//循环处理
            StringBuilder strb = new StringBuilder();
            if (value.getClass().isArray())
            {
                Object[] objs = Arrays.toArray(value);
                for (int i=0;i<objs.length;i++)
                {
                    int status = each(objs[i], i, variableMap, strb);
                    if (status == 1)
                        break;
                    
                    if (status == 2)
                        continue;
                }
            }
            else
            {
                Iterator<?> it = null;
                if (value instanceof Iterable)
                    it = ((Iterable<?>)value).iterator();
                else
                    it = (Iterator<?>)value;
                
                for (int i=0;it.hasNext();i++)
                {
                    Object obj = it.next();
                    
                    int status = each(obj, i, variableMap, strb);
                    if (status == 1)
                        break;
                    
                    if (status == 2)
                        continue;
                }
            }
            
            if (isEndBreak())
            {//如果结束是独占一行，则删除最后的回车 TODO
                int length = strb.length();
                if (length > 0 && (strb.charAt(length-1) == _CR_ || strb.charAt(length-1) == _LF_))
                    strb.setLength(length-1);
                    
                length = strb.length();
                if (length > 0 && (strb.charAt(length-1) == _CR_ || strb.charAt(length-1) == _LF_))
                    strb.setLength(length-1);
            }
            
//            int length = strb.length();
//            if (length > 0 && isEndBreak())
//            {//如果结束是独占一行，则删除最后的回车
//                if (strb.charAt(length-1) == _CR_ || strb.charAt(length-1) == _LF_)
//                {
//                    strb.setLength(length-1);
//                }
//                
//                if (strb.charAt(length-2) == _CR_ || strb.charAt(length-2) == _LF_)
//                    strb.setLength(length-2);
//            }
            return strb.toString();
        }
        catch(Exception e)
        {
            throw new StatementException(this, FOR + e.getMessage(), e);
        }
    }
    
    private int each(Object obj, int index, ZmlVariable variableMap, StringBuilder strb) throws StatementException
    {
        //定义局部变量
        MapSO localMap = new HashMapSO(2);
        localMap.put(itemVariableName, obj);
        localMap.put(itemVariableName+"_index", index);
        variableMap.addLocalVariable(localMap);
        
        try
        {
            //循环处理语句列表
            StatementParser.processStatementList(stmtList, variableMap, strb);
        }
        catch (BreakException e) 
        {
            return 1;
        }
        catch (ContinueException e) 
        {
            return 2;
        }
        finally
        {//清除局部变量
            variableMap.removeLocalVariable(localMap);
            localMap.clear();localMap = null;
        }
        
        return 0;
    }
    
    /**********************************************/
    //两个临时数据，用于语句解析成嵌套语句列表
    /**********************************************/
    
    @Override
    public String getContent()
    {
        return content;
    }
    
    @Override
    public int getContentBeginIndex()
    {
        return contentBeginIndex;
    }
    
    @Override
    public String getPrevStatement(Statement stmt) throws StatementException
    {
        int ind = stmtList.indexOf(stmt);
        if (ind <= 0)
            return null;
        
        return stmtList.get(ind-1).getStatement();
    }
    
    @Override
    public String getNextStatement(Statement stmt) throws StatementException
    {
        int ind = stmtList.indexOf(stmt);
        if (ind == -1 || ind >= stmtList.size()-1)
            return null;
        
        return stmtList.get(ind+1).getStatement();
    }
}
