/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.statement;

import org.zhiqim.kernel.util.Strings;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;

/**
 * 响应语句，调用语句并显示返回值，格式为：${obj.getName()}
 * @see _Call   调用不显示返回值
 * @see _Format 调用显示格式化的返回值
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Echo extends Statement
{
    private Expression _expression;
    
    @Override
    public boolean isNesting()
    {
        return false;
    }
    
    @Override
    public void parseStatement() throws StatementException
    {
        String s = Strings.trim(getStatement(), ECHO_BEGIN, ECHO_END);
        
        try
        {
            _expression = ExpressionParser.parseExpression(s);
        }
        catch(Exception e)
        {
            throw new StatementException(this, ECHO + e.getMessage());
        }
    }
    
    @Override
    public String process(ZmlVariable variableMap) throws StatementException
    {
        Object value = null;
        
        try
        {
            value = _expression.build(variableMap);
        }
        catch(Exception e)
        {
            throw new StatementException(this, ECHO + e.getMessage(), e);
        }
        
        //结果为null返回null表示无返回文本，不为null转化为字符串
        return (value == null)?null:String.valueOf(ZmlVariable.chkDynamicVar(value));
    }
}
