/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.primitive;

import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Primitive;
import org.zhiqim.zml.expression.operator._Negative;

/**
 * 小数原型，float/double，零点开头后面为数字，或非零数字开头数字和一个点号连贯出现"^(0|[1-9]\\d*)(\\.\\d+)?$"
 * 
 * @see _Negative  逻辑取负，如果前面有-号，则为负小数原型
 * 
 * @see Float       四个字节
 * @see Double      八个字节
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Decimal extends Primitive
{
    private final String value;
    
    public _Decimal(String value)
    {
        this.value = value;
    }
    
    @Override
    public int getType()
    {
        return DECIMAL;
    }
    
    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        return Double.parseDouble(value);
    }
    
    @Override
    public String toString()
    {
        return value;
    }
    
    public double getDouble()
    {
        return Double.parseDouble(value);
    }
    
    public float getFloat()
    {
        return Float.parseFloat(value);
    }
}
