/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;

/**
 * 三目运算（?a:b）
 *
 * @version v1.0.0 @author zouzhigang 2018-1-2 新建与整理
 */
public class _Ternary extends Operator
{
    private Expression obj;
    private Expression first;
    private Expression second;
    
    public _Ternary(Expression condition, Expression first, Expression second)
    {
        this.obj = condition;
        this.first = first;
        this.second = second;
    }
    
    @Override
    public int getType()
    {
        return TERNARY;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        Object value = obj.build(variableMap);
        if (value == null)
        {//为null时，采用js的规则，判断为false
            return second.build(variableMap);
        }
        
        if (value instanceof Boolean)
        {//值为boolean型
            return ((Boolean)value)?first.build(variableMap):second.build(variableMap);
        }
        
        //非null且非boolean的不支持
        throw new ExpressionException("三目表达式{"+this+"}格式不正常，条件不是布尔型");
    }
}
