/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.kernel.util.Types;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;

/**
 * 加法运算(+)<br><br>
 *
 * 1、数值型相加<br>
 * 2、字符串相连<br>
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Add extends Operator
{
    private final Expression left;
    private final Expression right;
    
    public _Add(Expression left, Expression right)
    {
        this.left = left;
        this.right = right;
    }
    
    @Override
    public int getType()
    {
        return ADD;
    }
    
    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        Object privous = left.build(variableMap);
        Object next = right.build(variableMap);
        if (privous instanceof String || next instanceof String)
        {//有一个是字符串则认为是字符串相连
            String str1 = String.valueOf(privous);
            String str2 = String.valueOf(next);
            return str1 + str2;
        }
        else if ((!Types.isNumber(privous) && !Types.isChar(privous))
            || (!Types.isNumber(next) && !Types.isChar(next)))
        {//不是整数和小数
            throw new ExpressionException("加法表达式{"+this+"}，格式不正确，出现加数不是数值型和字符串");
        }
        else
        {
            if (Types.isInteger(privous))
            {//整数
                long add1 = ((Number)privous).longValue();
                if (Types.isInteger(next))
                {
                    long add2 = ((Number)next).longValue();
                    return add1 + add2;
                }
                else if (Types.isDecimal(next))
                {
                    double add2 = ((Number)next).doubleValue();
                    return add1 + add2;
                }
                else
                {
                    char add2 = (Character)next;
                    return add1 + add2;
                }
            }
            else if (Types.isDecimal(privous))
            {//小数
                double add1 = (Double)privous;
                if (Types.isInteger(next))
                {
                    long add2 = ((Number)next).longValue();
                    return add1 + add2;
                }
                else if (Types.isDecimal(next))
                {
                    double add2 = ((Number)next).doubleValue();
                    return add1 + add2;
                }
                else
                {
                    char add2 = (Character)next;
                    return add1 + add2;
                }
            }
            else
            {//字符
                char add1 = (Character)privous;
                if (Types.isInteger(next))
                {
                    long add2 = ((Number)next).longValue();
                    return add1 + add2;
                }
                else if (Types.isDecimal(next))
                {
                    double add2 = ((Number)next).doubleValue();
                    return add1 + add2;
                }
                else
                {
                    char add2 = (Character)next;
                    return add1 + add2;
                }
            }
        }
    }
    
    @Override
    public String toString()
    {
        return new StringBuilder().append(left).append(" + ").append(right).toString() ;
    }
}
