/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.exception;

/**
 * 定义表达式解析异常
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ExpressionException extends Exception
{
    private static final long serialVersionUID = 1L;
    
    /**
     * 断言，传入要断言的判断，为false时抛出非法的参数异常
     * 
     * @param param                 断言为false时抛出非法的参数异常
     * @param exception             异常信息
     * @throws ExpressionException  异常
     */
    public static void asserts(boolean param, String exception) throws ExpressionException
    {
        if (!param){
            throw new ExpressionException(exception);
        }
    }
    
    /**
     * 断言对象不为null，如果为null则抛出非法的参数异常
     * 
     * @param param         参数
     * @param exception     异常信息
     * @throws ExpressionException  异常
     */
    public static void assertNotNull(Object param, String exception) throws ExpressionException
    {
        if (param == null){
            throw new ExpressionException(exception);
        }
    }

    public ExpressionException(String message)
    {
        super(message);
    }
    
    public ExpressionException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
