/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml;

import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.zml.statement._Var;

/**
 * ZhiqimML变量更新通知
 *
 * @version v1.0.0 @author zouzhigang 2016-7-13 新建与整理
 */
public interface ZmlVarNotice
{
    /**
     * 回调更新变量的接口定义
     * 
     * @param zml               ZML对象
     * @param configPath        配置路径
     * @param componentPath     组件路径
     * @param varMap            变量表
     */
    public void doUpdateVariable(Zml zml, String configPath, String componentPath, LinkedMapSV<_Var> varMap);
}
