/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml;

/**
 * ZhiqimML行索引，定义每行对应的索引
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZmlLineIndex
{
    private int lineNo;
    
    private int beginIndex;
    private int endIndex;
    
    /** 指定总索引号，判断是否在该行，如果不在返回-1，否则返在该行号 */
    public int getLineNo(int ind)
    {
        if (ind < beginIndex || ind > endIndex)
            return -1;
        else
            return lineNo + 1;
    }
    
    /** 指定总索引号，判断是否在该行，如果不在返回-1，否则返在该行对应的列号 */
    public int getColumnNo(int ind)
    {
        if (ind < beginIndex || ind > endIndex)
            return -1;
        
        return ind - beginIndex + 1;
    }

    public int getBeginIndex()
    {
        return beginIndex;
    }

    public void setBeginIndex(int beginIndex)
    {
        this.beginIndex = beginIndex;
    }

    public int getEndIndex()
    {
        return endIndex;
    }

    public void setEndIndex(int endIndex)
    {
        this.endIndex = endIndex;
    }

    public int getLineNo()
    {
        return lineNo;
    }

    public void setLineNo(int lineNo)
    {
        this.lineNo = lineNo;
    }
}
