/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml;

import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;
import org.zhiqim.zml.expression.Primitive;

/**
 * 表达式基类<br><br>
 *  
 * @see Operator 运算符表达式<br>
 * @see Primitive  对象原型表达式<br>
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface Expression extends ZmlConstants
{
    /** 
     * 强制子类实现toString方法 
     * 
     * @return 表达式原型字符串
     */
    public String toString();
    
    /**
     * 强制子类提供表达式类型，方便switch
     * 
     * @return 表达式int类型
     */
    public int getType();
    
    /**
     * 根据变量列表生成结果值
     * 
     * @param variableMap           变量表
     * @return                      结果值
     * @throws ExpressionException  可能的表达式异常
     */
    public Object build(ZmlVariable variableMap) throws ExpressionException;
}
