/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.defined;

import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;

/**
 * 视图连接条件格式，支持以下四种格式，配置格式如：<br><br>
 * 1.左表列=右表列<join type="EQUAL" lTable="USER" lColumn="USER_ID" rTable="USER_EX" rColumn="USER_ID"/><br>
 * 2.左表列 left join in 右表列<where type="LEFT" lTable="USER" lColumn="USER_ID" rTable="USER_EX" rColumn="USER_ID"/><br>
 * 3.左表列 right join in 右表列<where type="RIGHT" lTable="USER" lColumn="USER_ID" rTable="USER_EX" rColumn="USER_ID"/><br>
 * 4.左表列=固定值<where type="RIGHT" lTable="USER" lColumn="USER_ID" rValue="zouzhigang"/>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _ViewJoin implements ORMConstants
{
    private String type;
    
    private String lTable;
    private String lColumn;
    private String rTable;
    private String rColumn;
    private String rValue;
    
    public _ViewJoin(String type, String lTable, String lColumn, String rTable, String rColumn, String rValue)
    {
        this.type = type;
        this.lTable = lTable;
        this.lColumn = lColumn;
        this.rTable = rTable;
        this.rColumn = rColumn;
        this.rValue = rValue;
    }
    
    public String toString()
    {
        StringBuilder strb = new StringBuilder("<join");
        strb.append(" type=").append(_DOUBLE_QUOTE_).append(type).append(_DOUBLE_QUOTE_);
        strb.append(" lTable=").append(_DOUBLE_QUOTE_).append(lTable).append(_DOUBLE_QUOTE_)
            .append(" lColumn=").append(_DOUBLE_QUOTE_).append(lColumn).append(_DOUBLE_QUOTE_);
        
        if (Validates.isNotEmpty(rColumn))
            strb.append(" rTable=").append(_DOUBLE_QUOTE_).append(rTable).append(_DOUBLE_QUOTE_)
            .append(" rColumn=").append(_DOUBLE_QUOTE_).append(rColumn).append(_DOUBLE_QUOTE_);
        else
            strb.append(" rValue=").append(_DOUBLE_QUOTE_).append(rValue).append(_DOUBLE_QUOTE_);
        
        return strb.append("/>").toString();
    }
    
    public String getType()
    {
        return type;
    }
    public String getLTable()
    {
        return lTable;
    }
    public String getLColumn()
    {
        return lColumn;
    }
    public String getRTable()
    {
        return rTable;
    }
    public String getRColumn()
    {
        return rColumn;
    }
    public String getRValue()
    {
        return rValue;
    }
}
