/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.defined;

import org.zhiqim.kernel.util.Strings;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.dbo.DboField;

/**
 * 标准字段格式，配置格式如：<br><br>
 * <field field="userId" column="USER_ID" type="string,19,char" notNull="true"/><br>
 * 和_Table一起组装
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _TableField implements ORMConstants, DboField
{
    private String field;
    private String column;
    private String type;
    private boolean notNull;
    
    public _TableField(String name, String column, String type, boolean notNull)
    {
        this.field = name;
        this.column = column;
        this.type = type;
        this.notNull = notNull;
    }
    
    public String toString()
    {
        return new StringBuilder("<field")
            .append(" field=").append(_DOUBLE_QUOTE_).append(field).append(_DOUBLE_QUOTE_)
            .append(" column=").append(_DOUBLE_QUOTE_).append(column).append(_DOUBLE_QUOTE_)
            .append(" style=").append(_DOUBLE_QUOTE_).append(type).append(_DOUBLE_QUOTE_)
            .append(" notNull=").append(_DOUBLE_QUOTE_).append(notNull).append(_DOUBLE_QUOTE_)
            .append("/>")
            .toString();
    }
    
    public String getField()
    {
        return field;
    }

    public String getColumn()
    {
        return column;
    }

    public int getType()
    {
        return ORMType.getColumnTypeMaybeLength(type);
    }
    
    public String getTypeAndLength()
    {
        return type;
    }
    
    public boolean isNotNull()
    {
        return notNull;
    }
    
    public String getSetMethod()
    {
        if (getType() != Z_ORM_BOOLEAN_INT || !Strings.startsWith(field, "is"))
            return "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
        else
            return "set" + field.substring(2);
    }
    
    public String getGetMethod()
    {
        if (getType() != Z_ORM_BOOLEAN_INT)
            return "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
        
        if (Strings.startsWith(field, "is"))
            return field;
        else
            return "is" + field.substring(0, 1).toUpperCase() + field.substring(1);
    }
}
