/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.defined;

import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.DboField;


/**
 * 数据库参数或结果格式，配置格式如：<br><br>
 * <dbo name="com.zhiqim.data.User"><br>
 *     <field name="userId" column="USER_ID" type="long"/><br>
 *     <field name="userName" column="USER_NAME" type="String"/><br>
 * </dbo><br><br>
 * 用于ZSQL时根据column和type反射机制组装数据对象
 *
 * 注：_Dbo支持通过column找到_DboField
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Dbo implements ORMConstants, Dbo
{
    private String name;        //类名
    
    private LinkedMapSV<_DboField> fieldMap = new LinkedMapSV<>();
    
    public _Dbo(String name)
    {
        this.name = name;
    }
    
    public void addField(String name, String column, String type)
    {
        _DboField field = new _DboField(name, column, type);
        fieldMap.put(name, field);
    }
    
    public String toString()
    {
        StringBuilder strb = new StringBuilder(_FOUR_).append("<dbo")
            .append(" name=").append(_DOUBLE_QUOTE_).append(name).append(_DOUBLE_QUOTE_)
            .append(">").append(_BR_);
        
        for (_DboField field : fieldMap.values())
        {
            strb.append(_FOUR_).append(_FOUR_).append(field).append(_BR_);
        }
        
        strb.append(_FOUR_).append("</dbo>");
        return strb.toString();
    }
    
    public String getName()
    {
        return name;
    }
    
    /** 判断是否是有相等的连接条件 */
    public boolean hasEqualJoin()
    {//不是视图直接返回false
        return false;
    }
    
    /** 判断是否存在该字段 */
    public boolean hasField(String fieldName)
    {
        return fieldMap.containsKey(fieldName)?true:getFieldByColumn(fieldName)!=null;
    }
    
    /** 通过字段获取数据库列名 */
    public String getColumn(String fieldName)
    {
        _DboField field = getField(fieldName);
        return (field == null)?null:field.getColumn();
    }
    
    /** 根据名称查字段get方法 */
    public String getGetMethod(String name)
    {
        //先判断是否是字段名,再判断是否是表列名
        _DboField field = getField(name);
        return (field == null)?null:field.getGetMethod();
    }
    
    /** 根据名称查字段 */
    public _DboField getField(String name)
    {
        //先查字段名,再查表列名
        _DboField field = fieldMap.get(name);
        if (field == null)
            field = getFieldByColumn(name);
        
        return field;
    }
    
    /** 通过列名找到字段 */
    public _DboField getFieldByColumn(String column)
    {
        for (_DboField field : fieldMap.values())
        {
            if (field.getColumn().equals(column))
                return field;
        }
        
        return null;
    }
    
    /** 获取字段列表按长度排序 */
    public DboField[] getFieldColumnListOrderByLen()
    {
        _DboField[] array = new _DboField[fieldMap.size()];
        int index = 0;
        for (_DboField field : fieldMap.values())
        {
            array[index++] = field;
        }
        
        for (int i=0;i<array.length;i++)
        {
            for (int j=i+1;j<array.length;j++)
            {
                if (array[i].getField().length() < array[j].getField().length())
                {//冒泡交换
                    _DboField v = array[i];
                    array[i] = array[j];
                    array[j] = v;
                }
            }
        }
        
        return array;
    }
}