/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.condition;

import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Dbo;


/**
 * 比较类型的条件，一共支持9种
 * 
 * @see _Equal      相等
 * @see _EqualNot   不等
 * @see _ThenG      大于
 * @see _ThenGE     大于等于
 * @see _ThenL      小于
 * @see _ThenLE     小于等于
 * @see _Like       两边like
 * @see _LikeL      左边like
 * @see _LikeR      右边like
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class _Compare extends Condition
{
    protected String field;
    protected Object value;
    protected String compare;
    
    public _Compare(String field, Object value, String compare)
    {
        this.field = field;
        this.value = value;
        this.compare = compare;
    }
    
    public String toSql(Dbo dbo, MapSO paramMap) throws ORMException
    {
        assertField(dbo, field);
        
        String column = dbo.getColumn(field);

        int ind = paramMap.size();
        paramMap.put(field+ind, convertValue(value));//把值放到表中，后续方便把##转成?号，然后再设置值
        
        return new StringBuilder()
            .append(column).append(_SPACE_).append(compare).append(_SPACE_)
            .append("#").append(field+ind).append("#")
            .toString();
    }
    
    public String getField()
    {
        return field;
    }
    
    public Object getValue()
    {
        return value;
    }
}
