/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

import java.io.Serializable;

/**
 * 更新器字段说明
 * 
 * 1.更新字段=某值
 * 2.更新字段为表达式
 *
 * @version v1.0.0 @author zhichenggang 2014-3-21 新建与整理
 */
public class UpdaterField implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    private String field;
    private Object value;
    private int type;//=0表示值，=1表示表达式,其中表达式支持字段替换
    
    UpdaterField(String field, Object value)
    {
        this.field = field;
        this.value = value;
        this.type = 0;
    }
    
    UpdaterField(String field, Object value, int type)
    {
        this.field = field;
        this.value = value;
        this.type = type;
    }
    
    public String getField()
    {
        return field;
    }

    public Object getValue()
    {
        return value;
    }

    public int getType()
    {
        return type;
    }
}
