/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.orm.ORMException;

/**
 * 对象更新器，支持更新字段列表，和查询条件列表
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Updater")
@AnNew
public class Updater extends Conditioner<Updater>
{
    private static final long serialVersionUID = 1L;
    private LinkedMapSV<UpdaterField> fieldMap = new LinkedMapSV<>();
    
    /** 检查有效性 */
    public boolean isValid() throws ORMException
    {
        //完成field
        if (fieldMap.isEmpty() || conditionList.isEmpty())
            return false;
        else
            return true;            
    }
    
    /**
     * 增加适配信息
     * 
     * @param key   适配建
     * @param value 适配值
     * @return      返回本对象
     */
    public Updater addReplace(String key, String value)
    {
        addReplaceInner(key, value);
        return this;
    }
    
    /******************************************************/
    //字段管理
    /******************************************************/
    
    /**
     * 增加更新字段
     * 
     * @param field 更新字段
     */
    public Updater addField(String field, Object value)
    {
        fieldMap.put(field, new UpdaterField(field, value));
        return this;
    }
    
    public Updater addFieldExpression(String field, String expression)
    {
        fieldMap.put(field, new UpdaterField(field, expression, 1));
        return this;
    }
    
    public LinkedMapSV<UpdaterField> getFieldList()
    {
        return fieldMap;
    }
}
