/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

/**
 * 数据库对象字段模型，(_DboField, _TableField, _ViewField)三个子类<br><br>
 * 1. @see _DboField     数据库查询结构对象的字段
 * 2. @see _TableField      数据库表列，描述类字段和数据库表列名的映射关系，如字段userName对应表列名USER_NAME,类型为String<br>
 * 3. @see _ViewField       数据库视图关联列，比_TableField多一个table字段，用于指定某个表的列名和类型<br>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface DboField
{
    /** 字段数据类型，当前支持共9种 */
    public int getType();
    
    /** 字段SET方法，用于运行时反射机制赋值 */
    public String getSetMethod();

    /** 字段SET方法，用于运行时反射机制赋值 */
    public String getGetMethod();
    
    /** 获取字段名 */
    public String getField();
    
    /** 获取列名 */
    public String getColumn();
}
