/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.orm.ORMException;

public abstract class Condition implements SignConstants
{
    //比较条件
    public static final String EQUAL                           = "=";           //=            等于
    public static final String EQUAL_NOT                       = "<>";          //<>           不等
    public static final String LIKE                            = "like";        //like         两边都LIKE %value%,左边%value,右边value%
    public static final String LIKE_NOT                        = "not like";    //not like         两边都LIKE %value%,左边%value,右边value%
    public static final String THEN_G                          = ">";           //>            大于
    public static final String THEN_GE                         = ">=";          //>=           大于等于
    public static final String THEN_L                          = "<";           //<            小于
    public static final String THEN_LE                         = "<=";          //<=           小于等于
    //判断条件
    public static final String IS_NULL                         = "is null";     //is null      为空
    public static final String IS_NOT_NULL                     = "is not null"; //is not null  不为空
    public static final String IN                              = "in";          //in           包含
    public static final String IN_NOT                          = "not in";      //not in       不包含
    //多重条件
    public static final String OR                              = "or";          //or           或者
    
    /*******************************************************************/
    //子类必须实现的方法
    /*******************************************************************/
    
    /**
     * 判断对象是否匹配
     * 
     * @param obj               比较的对象
     * @return                  =true表示匹配成功
     */
    public abstract boolean match(Object obj);
    
    /**
     * 生成FDbo对应的条件SQL
     * 
     * @param dbo               _Dbo/_Table/_View三种的一种
     * @param paramMap          由Selector/Updater指定的参数表
     * @return                  SQL
     * @throws ORMException     异常
     */
    public abstract String toSql(Dbo dbo, MapSO paramMap) throws ORMException;
    
    
    /*******************************************************************/
    //内部断言方法和值转换方法
    /*******************************************************************/
    
    /**
     * 验证字段在DBO中的有效性
     * 
     * @param dbo               数据库对象
     * @param field             字段
     * @throws ORMException     异常
     */
    protected void assertField(Dbo dbo, String field) throws ORMException
    {
        if (!dbo.hasField(field))
            throw new ORMException("ZTable/ZView["+dbo.getName()+"]配置中未找到["+field+"]属性");
    }
    
    /**
     * 断言是否是int[],long[],String[]三种
     * 
     * @param value             值
     * @throws ORMException     异常
     */
    protected void assertArray(Object value) throws ORMException
    {
        if (!(value instanceof int[]) && !(value instanceof long[]) && !(value instanceof String[]))
            throw new ORMException("ZTable/ZView[in/not in]仅支持int[],long[],String[]三种数组类型");
    }
    
    /**
     * 值转换，针对对象转换成数据库支持的类型
     * 
     * @param value     原值
     * @return          转换后的值
     */
    protected Object convertValue(Object value)
    {
        if (value instanceof Boolean)
        {//boolean型转换成int型
            boolean b = (Boolean)value;
            return b?1:0;
        }

        return value;
    }
    
    /**
     * 值转换，针对in/not in把对象转换成数组格式
     * 
     * @param value     原值
     * @return          转换后的值
     */
    protected String convertArray(Object value)
    {
        if (value instanceof int[])
            return "("+Arrays.toString((int[])value, ",") + ")";
        else if (value instanceof long[])
            return "("+Arrays.toString((long[])value, ",") + ")";
        else
            return "("+Arrays.toStringSql((String[])value, ",") + ")";
    }
}
