/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

import java.sql.CallableStatement;
import java.sql.SQLException;

import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.datasource.ZCall;

/**
 * 调用参数
 *
 * @version v1.4.1 @author zouzhigang 2018-7-23 新建与整理
 */
public final class CallParam implements ORMConstants
{
    private CALL_TYPE type;
    private Class<?> clazz;
    private Object value;
    
    private CallParam(CALL_TYPE type, Class<?> clazz)
    {
        this.type = type;
        this.clazz = clazz;
    }
    
    private CallParam(CALL_TYPE type, Object value)
    {
        this.type = type;
        this.value = value;
        this.clazz = value.getClass();
    }
    
    public CALL_TYPE type()
    {
        return type;
    }
    
    public Object value()
    {
        return value;
    }
    
    /**********************************************************************************/
    //三种生成参数对象
    /**********************************************************************************/
    
    public boolean isInWrite()
    {
        return this.type == CALL_TYPE.IN || this.type == CALL_TYPE.INOUT;
    }
    
    public boolean isOutRead()
    {
        return this.type == CALL_TYPE.OUT || this.type == CALL_TYPE.INOUT;
    }
    
    public int typeSQL()
    {
        return ZCall.getType(clazz);
    }
    
    public void value(CallableStatement cstmt, int index) throws SQLException
    {
        value = ZCall.getValue(clazz, cstmt, index);
    }
    
    /**********************************************************************************/
    //三种生成参数对象
    /**********************************************************************************/
    
    public static CallParam in(Object value)
    {
        return new CallParam(CALL_TYPE.IN, value);
    }
    
    public static CallParam inout(Object value)
    {
        return new CallParam(CALL_TYPE.INOUT, value);
    }
    
    public static CallParam out(Class<?> clazz)
    {
        return new CallParam(CALL_TYPE.OUT, clazz);
    }
}
