/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;

/**
 * 数据库关闭工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public final class ZDBClose
{
    private static final Log log = LogFactory.getLog(ZDBClose.class);

    /** 关闭连接结果集 */
    public static void close(ResultSet rst)
    {
        try
        {
            if (rst != null)
                rst.close();
        }
        catch (Exception e)
        {
            log.error(e.getMessage());
        }
    }
    
    /** 关闭连接属性 */
    public static void close(Statement stmt)
    {
        try
        {
            if (stmt != null)
                stmt.close();
        }
        catch (Exception e)
        {
            log.error(e.getMessage());
        }
    }
    
    /** 关闭连接属性 */
    public static void close(ResultSet rst, Statement stmt)
    {
        close(rst);
        close(stmt);
    }
    
    /** 关闭/归还连接 */
    public static void close(Connection conn)
    {
        try
        {
            if (conn != null)
                conn.close();
        }
        catch (SQLException e)
        {
            log.error(e.getMessage());
        }
    }
    
    /** 关闭和归还连接属性 */
    public static void close(Statement stmt, Connection conn)
    {
        close(stmt);
        close(conn);
    }
    
    /** 关闭和归还连接属性 */
    public static void close(ResultSet rst, Statement stmt, Connection conn)
    {
        close(rst);
        close(stmt);
        close(conn);
    }
}
