/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.config;

import java.io.InputStream;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zhiqim.kernel.constants.XmlConstants;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xmls;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;

/**
 * ZhiqimSQL配置信息，id和SQL语句<br><br>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZSQLConfig implements ORMConstants, XmlConstants
{
    private String name;
    private LinkedMapSS sqlMap = new LinkedMapSS();
    
    public ZSQLConfig(String name)
    {
        this.name = name;
    }
    
    public String toString()
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_XML_DEFIND_).append(_BR_);
        strb.append(Z_SQL_CONFIG_XML_DOCTYPE).append(_BR_);
        strb.append(Z_SQL_CONFIG_XML_HEAD).append(_BR_).append(_BR_);
        
        for (Map.Entry<String, String> entry : sqlMap.entrySet())
        {
            strb.append("<sql id=\">").append(entry.getKey()).append("\">").append(_BR_);
            strb.append("<![CDATA[").append(_BR_);
            strb.append(entry.getValue()).append(_BR_);
            strb.append("]]>").append(_BR_);
            strb.append("</sql>").append(_BR_);
        }
        strb.append(_BR_);
        
        strb.append(Z_SQL_CONFIG_XML_TAIL);
        return strb.toString();
    }
    
    /**
     * 加载XML
     * 
     * @param in            输入流
     * @throws Exception    可能的异常
     */
    public void load(InputStream in) throws Exception
    {
        Document document = Xmls.buildDocument(in, new ZSQLResolver());
        
        //遍历<sql>标签
        NodeList updateList = document.getElementsByTagName("sql");
        for (int i=0;i<updateList.getLength();i++)
        {
            Node node = updateList.item(i);
            if (node.getNodeType() != Node.ELEMENT_NODE)
                continue;
            
            String id = Xmls.getAttribute(node, _ID_);
            String sql = node.getTextContent();
            
            if (Validates.isEmptyBlank(sql))
                throw new ORMException("不允许SQL语句为空的配置,[id="+id+"]");
            
            sqlMap.put(id, Sqls.formatSpace(sql));
        }
    }
    
    public String getName()
    {
        return name;
    }
    
    public String getSQL(String id)
    {
        return sqlMap.get(id);
    }
    
    public LinkedMapSS getSQLMap()
    {
        return sqlMap;
    }
}
