/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm;

import java.sql.Connection;
import java.sql.SQLException;

import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionAbstracter;

/**
 * 实现事务接口，包括提交、回滚、关闭以及判断是否已提交和已回滚，该类只由事务管理器创建
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ORMTransaction extends TransactionAbstracter
{
    private Connection conn = null;
    private boolean autoCommit = true;
    
    public ORMTransaction(String id, Connection conn)
    {
        super(id);
        this.conn = conn;
    }
    
    /** 开始一个事务 */
    public Transaction begin() throws SQLException
    {
        autoCommit = conn.getAutoCommit();
        if (autoCommit)
            conn.setAutoCommit(false);
        return this;
    }

    /** 提交一个事务 */
    public void commit() throws SQLException
    {
        conn.commit();
        super.setCommitted();
    }

    /** 回滚一个事务 */
    public void rollback() throws SQLException
    {
        conn.rollback();
        super.setRollbacked();
    }
    
    /** 关闭一个事务 */
    public void close() throws SQLException
    {
        conn.setAutoCommit(autoCommit);
        conn.close();
        
        super.setClosed();
    }
}
