/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.control.Configurable;
import org.zhiqim.kernel.util.Asserts;

/**
 * ORM工具类，简化获取ORMServer的方法
 *
 * @version v1.0.0 @author zouzhigang 2018-11-26 新建与整理
 */
@AnAlias("ORM")
public class ORM implements ORMConstants
{
    /***********************************************************************************/
    //ORM通用对象
    /***********************************************************************************/
    
    /** 获取ORM中的第一个对象 */
    public static <T> T get(Class<T> cls)
    {
        return get(cls, 0);
    }
    
    /** 获取ORM中指定可配置对象 */
    public static <T> T get(Class<T> cls, Configurable config)
    {
        return get(cls, config.getConfiguration());
    }
    
    /** 获取ORM中指定ID的对象 */
    @SuppressWarnings("unchecked")
    public static <T> T get(Class<T> cls, String id)
    {
        if (cls == ZTable.class)
            return (T)table(id);
        else if (cls == ZView.class)
            return (T)view(id);
        else if (cls == ZSQL.class)
            return (T)sql(id);
        else if (cls == ZDDL.class)
            return (T)ddl(id);
        else if (cls == ZTabler.class)
            return (T)tabler(id);
        else if (cls == ORMServer.class)
            return (T)server(id);
        else
            throw Asserts.exception("不支持的ORM对象");
    }
    
    /** 获取ORM中指定索引的对象 */
    @SuppressWarnings("unchecked")
    public static <T> T get(Class<T> cls, int idx)
    {
        if (cls == ZTable.class)
            return (T)table(idx);
        else if (cls == ZView.class)
            return (T)view(idx);
        else if (cls == ZSQL.class)
            return (T)sql(idx);
        else if (cls == ZDDL.class)
            return (T)ddl(idx);
        else if (cls == ZTabler.class)
            return (T)tabler(idx);
        else if (cls == ORMServer.class)
            return (T)server(idx);
        else
            throw Asserts.exception("不支持的ORM对象");
    }
    
    /***********************************************************************************/
    //ORM服务对象
    /***********************************************************************************/
    
    /** 获取第一个ORM服务 */
    public static ORMServer server()
    {
        return Global.getService(ORMServer.class);
    }
    
    /** 获取指定ID的ORM服务 */
    public static ORMServer server(String id)
    {
        return Global.getService(ORMServer.class, id);
    }
    
    /** 获取指定索引的ORM服务 */
    public static ORMServer server(int idx)
    {
        return Global.getService(ORMServer.class, idx);
    }
    
    /** 获取指定可配置对象的ORM服务 */
    public static ORMServer server(Configurable config)
    {
        return server(config.getConfiguration());
    }
    
    /***********************************************************************************/
    //表指令对象
    /***********************************************************************************/
    
    /** 获取第一个表指令对象 */
    public static ZTable table()
    {
        return Global.getService(ORMServer.class).table();
    }
    
    /** 获取指定ID的表指令对象 */
    public static ZTable table(String id)
    {
        return Global.getService(ORMServer.class, id).table();
    }
    
    /** 获取指定索引的表指令对象 */
    public static ZTable table(int idx)
    {
        return Global.getService(ORMServer.class, idx).table();
    }
    
    /** 获取指定可配置对象的表指令对象 */
    public static ZTable table(Configurable config)
    {
        return table(config.getConfiguration());
    }
    
    /***********************************************************************************/
    //视图指令对象
    /***********************************************************************************/
    
    /** 获取第一个视图指令对象 */
    public static ZView view()
    {
        return Global.getService(ORMServer.class).view();
    }
    
    /** 获取指定ID的视图指令对象 */
    public static ZView view(String id)
    {
        return Global.getService(ORMServer.class, id).view();
    }
    
    /** 获取指定索引的视图指令对象 */
    public static ZView view(int idx)
    {
        return Global.getService(ORMServer.class, idx).view();
    }
    
    /** 获取指定可配置对象的视图指令对象 */
    public static ZView view(Configurable config)
    {
        return view(config.getConfiguration());
    }
    
    /***********************************************************************************/
    //SQL指令对象
    /***********************************************************************************/
    
    /** 获取第一个SQL指令对象 */
    public static ZSQL sql()
    {
        return Global.getService(ORMServer.class).sql();
    }
    
    /** 获取指定ID的SQL指令对象 */
    public static ZSQL sql(String id)
    {
        return Global.getService(ORMServer.class, id).sql();
    }
    
    /** 获取指定索引的SQL指令对象 */
    public static ZSQL sql(int idx)
    {
        return Global.getService(ORMServer.class, idx).sql();
    }
    
    /** 获取指定可配置对象的SQL指令对象 */
    public static ZSQL sql(Configurable config)
    {
        return sql(config.getConfiguration());
    }
    
    /***********************************************************************************/
    //DDL指令对象
    /***********************************************************************************/
    
    /** 获取第一个DDL指令对象 */
    public static ZDDL ddl()
    {
        return Global.getService(ORMServer.class).ddl();
    }
    
    /** 获取指定ID的DDL指令对象 */
    public static ZDDL ddl(String id)
    {
        return Global.getService(ORMServer.class, id).ddl();
    }
    
    /** 获取指定索引的DDL指令对象 */
    public static ZDDL ddl(int idx)
    {
        return Global.getService(ORMServer.class, idx).ddl();
    }
    
    /** 获取指定可配置对象的DDL指令对象 */
    public static ZDDL ddl(Configurable config)
    {
        return ddl(config.getConfiguration());
    }
    
    /***********************************************************************************/
    //表管理指令对象
    /***********************************************************************************/
    
    /** 获取第一个表管理指令对象 */
    public static ZTabler tabler()
    {
        return Global.getService(ORMServer.class).tabler();
    }
    
    /** 获取指定ID的表管理指令对象 */
    public static ZTabler tabler(String id)
    {
        return Global.getService(ORMServer.class, id).tabler();
    }
    
    /** 获取指定索引的表管理指令对象 */
    public static ZTabler tabler(int idx)
    {
        return Global.getService(ORMServer.class, idx).tabler();
    }
    
    /** 获取指定可配置对象的表管理指令对象 */
    public static ZTabler tabler(Configurable config)
    {
        return tabler(config.getConfiguration());
    }
}
